/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.Target;
import com.comalatech.confluence.documentActivity.domain.entities.TargetAttachment;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GenericEventActivityMapper {
    protected final ActorUtils actorUtils;

    public GenericEventActivityMapper(ActorUtils actorUtils) {
        this.actorUtils = actorUtils;
    }

    public static Target buildTarget(long id, int version, Long spaceId, List<Attachment> pageAttachments) {
        Target target = new Target();
        target.setTargetId(id);
        target.setTargetVersion(version);
        target.setSpaceId(spaceId);
        if (pageAttachments != null && !pageAttachments.isEmpty()) {
            ArrayList<TargetAttachment> targetAttachments = new ArrayList<TargetAttachment>();
            for (Attachment attachment : pageAttachments) {
                TargetAttachment targetAttachment = new TargetAttachment();
                targetAttachment.setTargetAttachmentId(attachment.getId());
                targetAttachment.setTargetAttachmentVersion(attachment.getVersion());
                targetAttachments.add(targetAttachment);
            }
            target.setAttachmentList(targetAttachments);
        }
        return target;
    }

    public static Target buildTarget(ContentEntityObject content) {
        if (content == null) {
            return null;
        }
        Long spaceId = null;
        if (content instanceof AbstractPage) {
            spaceId = ((AbstractPage)content).getOriginalVersionPage() == null ? Long.valueOf(((AbstractPage)content).getSpace().getId()) : Long.valueOf(((AbstractPage)content).getOriginalVersionPage().getSpace().getId());
        }
        return GenericEventActivityMapper.buildTarget(content.getOriginalVersionId() == null ? content.getId() : content.getOriginalVersionId().longValue(), content.getVersion(), spaceId, content.getAttachments());
    }

    protected ActionDetails buildStateActionDetails(PageState state) {
        ActionDetails stateDetails = new ActionDetails();
        if (state != null) {
            stateDetails.addDetail(ActionDetailType.STATE_NAME, state.getName());
            stateDetails.addDetail(ActionDetailType.STATE_ID, String.valueOf(state.getId()));
            stateDetails.addDetail(ActionDetailType.IS_PUBLISHED, String.valueOf(state.isPublished()));
            if (state.getColour() != null) {
                stateDetails.addDetail(ActionDetailType.STATE_COLOUR, String.valueOf(state.getColour()));
            }
        }
        return stateDetails;
    }

    protected ActionDetails buildApprovalsActionDetails(String approvalName, int approvalCheckId, String comment) {
        ActionDetails details = new ActionDetails();
        details.addDetail(ActionDetailType.APPROVAL_NAME, approvalName);
        details.addDetail(ActionDetailType.APPROVAL_ID, String.valueOf(approvalCheckId));
        if (comment != null && !StringUtils.isEmpty((CharSequence)comment)) {
            details.addDetail(ActionDetailType.APPROVAL_COMMENT, comment);
        }
        return details;
    }

    protected ActionDetails buildRoleNameActionDetails(String roleName) {
        ActionDetails actionDetails = new ActionDetails();
        if (!StringUtils.isEmpty((CharSequence)roleName)) {
            actionDetails.addDetail(ActionDetailType.APPROVAL_ROLE, roleName);
        }
        return actionDetails;
    }
}

