/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.api.service;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.documentActivity.api.entities.PublicAction;
import com.comalatech.confluence.documentActivity.api.entities.PublicActionDetail;
import com.comalatech.confluence.documentActivity.api.entities.PublicActionType;
import com.comalatech.confluence.documentActivity.api.entities.PublicActivity;
import com.comalatech.confluence.documentActivity.api.entities.PublicTarget;
import com.comalatech.confluence.documentActivity.api.entities.PublicTargetAttachment;
import com.comalatech.confluence.documentActivity.api.service.model.PublicDocumentActivityResult;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryScope;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityResult;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQueryFilter;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import com.comalatech.workflow.DocumentActivityService;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.model.document.activity.DocumentActivityQuery;
import com.comalatech.workflow.model.document.activity.DocumentActivityQueryFilter;
import com.comalatech.workflow.model.document.activity.TargetAttachment;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class PublicDocumentActivityService
implements DocumentActivityService {
    private final com.comalatech.confluence.documentActivity.service.DocumentActivityService internalActivityService;
    private final WorkflowPermissionManager workflowPermissionManager;
    private final PageManager pageManager;
    private final SpaceManager spaceManager;
    private final ActorUtils actorUtils;

    public PublicDocumentActivityService(com.comalatech.confluence.documentActivity.service.DocumentActivityService internalActivityService, WorkflowPermissionManager workflowPermissionManager, @ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager, @ComponentImport UserAccessor userAccessor, WorkflowUserAccessor workflowUserAccessor) {
        this.internalActivityService = internalActivityService;
        this.workflowPermissionManager = workflowPermissionManager;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.actorUtils = new ActorUtils(userAccessor, workflowUserAccessor);
    }

    private void validatePermissionsForPages(List<Long> pageIds) throws WorkflowException {
        ConfluenceUser user = WorkflowAuthenticatedUserThreadLocal.get();
        if (pageIds == null || pageIds.isEmpty()) {
            throw new WorkflowException("No pageIds were defined for this query. Add some page/s for your search");
        }
        for (Long pageId : pageIds.stream().filter(Objects::nonNull).collect(Collectors.toList())) {
            AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
            if (page == null) {
                throw new WorkflowException("Page not found " + pageId);
            }
            if (this.workflowPermissionManager.canViewDrafts(page, user)) continue;
            throw new WorkflowException("User " + user.getKey().getStringValue() + " doesn't have permission to see workflows on the page " + pageId);
        }
    }

    private void validatePermissionsForSpaces(List<String> spaces) throws WorkflowException {
        ConfluenceUser user = WorkflowAuthenticatedUserThreadLocal.get();
        if (spaces == null || spaces.isEmpty()) {
            throw new WorkflowException("No spaces were defined for this query. Add some space/s to query");
        }
        for (String spaceKey : spaces.stream().filter(Objects::nonNull).collect(Collectors.toList())) {
            Space space = this.spaceManager.getSpace(spaceKey);
            if (space == null) {
                throw new WorkflowException("Invalid space " + spaceKey);
            }
            if (this.workflowPermissionManager.canViewWorkflows(space, user)) continue;
            throw new WorkflowException("User " + user.getKey().getStringValue() + " is not an admin of space " + space.getName());
        }
    }

    private InternalDocumentActivityQuery toInternalPagesQuery(List<Long> pageIds, DocumentActivityQuery query) {
        return this.toInternalQuery(query, DocumentActivityQueryScope.createScopePages(pageIds));
    }

    private InternalDocumentActivityQuery toInternalSpacesQuery(List<String> spaceKeys, DocumentActivityQuery query) {
        return this.toInternalQuery(query, DocumentActivityQueryScope.createScopeSpaces(spaceKeys));
    }

    private InternalDocumentActivityQuery toInternalQuery(DocumentActivityQuery query, DocumentActivityQueryScope scope) {
        InternalDocumentActivityQuery internalQuery = new InternalDocumentActivityQuery();
        internalQuery.setOrder(query.getOrder());
        internalQuery.setOffset(query.getOffset());
        internalQuery.setLimit(query.getLimit());
        DocumentActivityQueryFilter filters = query.getFilters();
        DocumentActivityQueryFilter internalFilters = Objects.nonNull(filters) ? ((InternalDocumentActivityQueryFilter.InternalDocumentActivityQueryFilterBuilder)((InternalDocumentActivityQueryFilter.InternalDocumentActivityQueryFilterBuilder)((InternalDocumentActivityQueryFilter.InternalDocumentActivityQueryFilterBuilder)((InternalDocumentActivityQueryFilter.InternalDocumentActivityQueryFilterBuilder)((InternalDocumentActivityQueryFilter.InternalDocumentActivityQueryFilterBuilder)((InternalDocumentActivityQueryFilter.InternalDocumentActivityQueryFilterBuilder)((InternalDocumentActivityQueryFilter.InternalDocumentActivityQueryFilterBuilder)InternalDocumentActivityQueryFilter.builder().fromDate(filters.getFromDate())).toDate(filters.getToDate())).actors(filters.getActors())).participants(filters.getParticipants())).types(filters.getTypes())).stateNames(filters.getStateNames())).scope(scope)).build() : ((InternalDocumentActivityQueryFilter.InternalDocumentActivityQueryFilterBuilder)InternalDocumentActivityQueryFilter.builder().scope(scope)).build();
        internalQuery.setFilters(internalFilters);
        return internalQuery;
    }

    private com.comalatech.workflow.model.document.activity.DocumentActivityResult toPublicResult(DocumentActivityResult result) {
        return PublicDocumentActivityResult.builder().activities(this.toPublicActivities(result.getActivities())).hasMoreResults(result.getMetadata().isHasMoreResults()).build();
    }

    private List<com.comalatech.workflow.model.document.activity.Activity> toPublicActivities(List<Activity> activities) {
        return activities.stream().map(this::toPublicActivity).collect(Collectors.toList());
    }

    private PublicActivity toPublicActivity(Activity activity) {
        PublicActivity act = new PublicActivity();
        PublicTarget target = new PublicTarget();
        Long internalTargetId = activity.getTarget().getTargetId();
        AbstractPage abstractPage = this.pageManager.getAbstractPage(internalTargetId.longValue());
        if (Objects.nonNull(abstractPage) && Objects.nonNull(abstractPage.getOriginalVersionId())) {
            target.setTargetId(abstractPage.getOriginalVersionId());
        } else {
            target.setTargetId(internalTargetId);
        }
        target.setTargetVersionId(internalTargetId);
        target.setTargetVersion(activity.getTarget().getTargetVersion());
        Space space = this.spaceManager.getSpace(activity.getTarget().getSpaceId().longValue());
        if (space != null) {
            target.setSpaceKey(space.getKey());
        }
        if (Objects.nonNull(activity.getTarget().getAttachmentList())) {
            List<TargetAttachment> attachments = activity.getTarget().getAttachmentList().stream().map(att -> new PublicTargetAttachment(att.getTargetAttachmentId(), att.getTargetAttachmentVersion())).collect(Collectors.toList());
            target.setAttachmentList(attachments);
        }
        act.setTarget(target);
        act.setMoment(activity.getMoment());
        act.setAction(this.toPublicAction(activity.getAction()));
        return act;
    }

    private PublicAction toPublicAction(Action action) {
        PublicAction act = new PublicAction();
        act.setActionType(new PublicActionType(action.getActionType().getType().getValue(), action.getActionType().getSubtype().getValue()));
        act.setActionDetails(action.getActionDetails().stream().map(this::toPublicActionDetail).collect(Collectors.toList()));
        act.setActors(action.getActors().stream().map(this.actorUtils::actorToPublic).collect(Collectors.toList()));
        return act;
    }

    private PublicActionDetail toPublicActionDetail(ActionDetail actionDetail) {
        PublicActionDetail detail = new PublicActionDetail();
        detail.setKey(actionDetail.getKey());
        detail.setType(actionDetail.getType().getValue());
        detail.setValue(actionDetail.getValue());
        if (Objects.nonNull(actionDetail.getParticipants())) {
            detail.setParticipants(actionDetail.getParticipants().stream().map(this.actorUtils::actorToPublic).collect(Collectors.toList()));
        }
        return detail;
    }

    @Override
    public com.comalatech.workflow.model.document.activity.DocumentActivityResult getPagesActivity(List<Long> pageIds, DocumentActivityQuery query) throws WorkflowException {
        this.validatePermissionsForPages(pageIds);
        return this.toPublicResult(this.internalActivityService.getPublicActivity(this.toInternalPagesQuery(pageIds, query)));
    }

    @Override
    public com.comalatech.workflow.model.document.activity.DocumentActivityResult getSpacesActivity(List<String> spaceKeys, DocumentActivityQuery query) throws WorkflowException {
        this.validatePermissionsForSpaces(spaceKeys);
        return this.toPublicResult(this.internalActivityService.getPublicActivity(this.toInternalSpacesQuery(spaceKeys, query)));
    }
}

