/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.dataextractor.action;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.AbstractPageAction;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.user.User;
import com.comalatech.confluence.dataextractor.DataExtractorManager;
import com.comalatech.confluence.messaging.Message;
import com.comalatech.confluence.messaging.PageMessageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReadOnlyAccessBlocked
public class PopulateDataExtractorInPageAction
extends AbstractPageAction {
    private static final Logger log = LoggerFactory.getLogger(PopulateDataExtractorInPageAction.class);
    private DataExtractorManager dataExtractorManager;
    private PageMessageManager pageMessageManager;

    public String execute() {
        AbstractPage page = this.getPage();
        if (log.isDebugEnabled()) {
            log.debug("Starting populateDataExtractorInPageAction");
        }
        if (page != null) {
            boolean success;
            if (log.isDebugEnabled()) {
                log.debug("Populating page with URL: " + page.getUrlPath());
            }
            if (!(success = this.dataExtractorManager.updateAllContentProperties((EntityObject)page))) {
                this.pageMessageManager.setMessage(page, "Validation Failed", AuthenticatedUserThreadLocal.get(), "Some properties failed to be updated because the create/delete actions were not valid, please check server logs for further details.", Message.MacroParamStyle.ERROR.param, 30L);
                log.error("Validation failed while populating the properties");
            }
        } else {
            log.error("Page not found for PopulateDataExtractorInPageAction");
        }
        if (log.isDebugEnabled()) {
            log.debug("PopulateDataExtractorInPageAction successfully finished");
        }
        return "success";
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.EDIT, (Object)this.getPage());
    }

    public String getId() {
        return this.getPage().getIdAsString();
    }

    public void setDataExtractorManager(DataExtractorManager dataExtractorManager) {
        this.dataExtractorManager = dataExtractorManager;
    }

    public void setPageMessageManager(PageMessageManager pageMessageManager) {
        this.pageMessageManager = pageMessageManager;
    }
}

