/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.repository;

import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.migration.app.check.CheckResult;
import com.atlassian.migration.app.check.CheckResultBuilder;
import com.atlassian.migration.app.check.CheckSpec;
import com.atlassian.migration.app.check.CheckStatus;
import com.atlassian.migration.app.check.Container;
import com.atlassian.migration.app.check.MigrationPlanContext;
import com.atlassian.migration.app.check.PreMigrationCheckRepository;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.usecases.contracts.ValidatePreFlightCheck;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class DocumentManagementPreCheckRepository
implements PreMigrationCheckRepository {
    private static final Logger log = LoggerFactory.getLogger(DocumentManagementPreCheckRepository.class);
    private static final String COMALA_CHECK_KEY = "comalatech.migration.preflight.";
    private static final String RESTRICTIONS_CHECK = "restrictions";
    private static final String WORKFLOWS_ASSESSMENT_CHECK = "workflows";
    private static final String STEPS_TO_RESOLVE_RESTRICTIONS_WARNING = "steps-to-resolve-restrictions-found";
    private static final String STEPS_TO_RESOLVE_RESTRICTIONS_ERROR = "steps-to-resolve-restrictions-error";
    private static final String STEPS_TO_RESOLVE_WORKFLOWS_ASSESSMENT_WARNING = "steps-to-resolve-workflows-found";
    private static final String STEPS_TO_RESOLVE_WORKFLOWS_ASSESSMENT_ERROR = "steps-to-resolve-workflows-error";
    private final ValidatePreFlightCheck validatePreFlightCheck;
    private final ComalaI18nBean comalaI18nBean;
    private final GlobalSettingsManager globalSettingsManager;

    public DocumentManagementPreCheckRepository(ValidatePreFlightCheck validatePreFlightCheck, ComalaI18nBean comalaI18nBean, @ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager globalSettingsManager) {
        this.validatePreFlightCheck = validatePreFlightCheck;
        this.comalaI18nBean = comalaI18nBean;
        this.globalSettingsManager = globalSettingsManager;
    }

    @Override
    public Set<CheckSpec> getAvailableChecks() {
        HashSet<CheckSpec> checks = new HashSet<CheckSpec>();
        try {
            checks.add(this.createRestrictionsCheck());
            checks.add(this.createWorkflowAssessmentCheck());
        }
        catch (IllegalArgumentException e) {
            log.error("Error during the execution of the pre-checks {}", (Object)e.getMessage());
        }
        return checks;
    }

    @Override
    public CheckResult executeCheck(String checkId, MigrationPlanContext migrationPlanContext) {
        log.info("Running checks for plan {}", (Object)migrationPlanContext.getPlanName());
        log.info("Context of the migration: {}", (Object)Arrays.toString(migrationPlanContext.getContainers().toArray()));
        switch (checkId) {
            case "restrictions": {
                return this.checkContentRestrictions(migrationPlanContext.getContainers());
            }
            case "workflows": {
                return this.checkWorkflowsAssessment(migrationPlanContext.getContainers());
            }
        }
        throw new IllegalStateException("Unknown check: " + checkId);
    }

    private CheckSpec createRestrictionsCheck() {
        CheckSpec restrictionsCheck = new CheckSpec(RESTRICTIONS_CHECK, this.comalaI18nBean.getText("comalatech.migration.preflight.restrictions.check.title"), this.buildStepsToResolveRestrictionsTemplates());
        List<String> validationErrors = restrictionsCheck.validate();
        if (!validationErrors.isEmpty()) {
            log.warn("Validation errors found: " + validationErrors);
        }
        return restrictionsCheck;
    }

    private CheckSpec createWorkflowAssessmentCheck() {
        CheckSpec workflowsCheck = new CheckSpec(WORKFLOWS_ASSESSMENT_CHECK, this.comalaI18nBean.getText("comalatech.migration.preflight.workflows.check.title"), this.buildStepsToResolveWorkflowsTemplates());
        List<String> validationErrors = workflowsCheck.validate();
        if (!validationErrors.isEmpty()) {
            log.warn("Validation errors found: {}", validationErrors);
        }
        return workflowsCheck;
    }

    private CheckResult checkContentRestrictions(Set<Container> containers) {
        try {
            CheckResultBuilder builder = CheckResultBuilder.resultBuilder(CheckStatus.SUCCESS);
            List<String> spaceKeys = containers.stream().map(Container::getId).collect(Collectors.toList());
            if (this.validatePreFlightCheck.existsContentWithRestrictions(spaceKeys)) {
                builder = CheckResultBuilder.resultBuilder(CheckStatus.BLOCKING);
                builder.withStepsToResolveKey(STEPS_TO_RESOLVE_RESTRICTIONS_WARNING);
            }
            return builder.build();
        }
        catch (Exception e) {
            log.error("checkContentRestrictions - Exception: {}", (Object)e.getMessage(), (Object)e);
            return CheckResultBuilder.resultBuilder(CheckStatus.CHECK_EXECUTION_ERROR).withStepsToResolveKey(STEPS_TO_RESOLVE_RESTRICTIONS_ERROR).build();
        }
    }

    private CheckResult checkWorkflowsAssessment(Set<Container> containers) {
        try {
            CheckResultBuilder builder = CheckResultBuilder.resultBuilder(CheckStatus.WARNING);
            builder.withStepsToResolveKey(STEPS_TO_RESOLVE_WORKFLOWS_ASSESSMENT_WARNING);
            return builder.build();
        }
        catch (Exception e) {
            log.error("checkContentRestrictions - Exception: {}", (Object)e.getMessage(), (Object)e);
            return CheckResultBuilder.resultBuilder(CheckStatus.CHECK_EXECUTION_ERROR).withStepsToResolveKey(STEPS_TO_RESOLVE_WORKFLOWS_ASSESSMENT_ERROR).build();
        }
    }

    private Map<String, String> buildStepsToResolveRestrictionsTemplates() {
        HashMap<String, String> stepsToResolve = new HashMap<String, String>();
        stepsToResolve.put(STEPS_TO_RESOLVE_RESTRICTIONS_WARNING, "<paragraph>" + this.comalaI18nBean.getText("comalatech.migration.preflight.restrictions.check.warning.paragraph1") + "</> <paragraph>" + this.comalaI18nBean.getText("comalatech.migration.preflight.restrictions.check.warning.paragraph2") + "</> <ordered-item>" + this.comalaI18nBean.getText("comalatech.migration.preflight.restrictions.check.warning.orderedItem1", new Object[]{this.getBaseUrlWithoutScheme()}) + "</><ordered-item>" + this.comalaI18nBean.getText("comalatech.migration.preflight.restrictions.check.warning.orderedItem2") + "</><ordered-item>" + this.comalaI18nBean.getText("comalatech.migration.preflight.restrictions.check.warning.orderedItem3") + "</>");
        stepsToResolve.put(STEPS_TO_RESOLVE_RESTRICTIONS_ERROR, "<paragraph>" + this.comalaI18nBean.getText("comalatech.migration.preflight.restrictions.check.error.paragraph") + "</>");
        return stepsToResolve;
    }

    private Map<String, String> buildStepsToResolveWorkflowsTemplates() {
        HashMap<String, String> stepsToResolve = new HashMap<String, String>();
        stepsToResolve.put(STEPS_TO_RESOLVE_WORKFLOWS_ASSESSMENT_WARNING, "<paragraph>" + this.comalaI18nBean.getText("comalatech.migration.preflight.workflows.check.warning.paragraph") + "</> <paragraph>" + this.comalaI18nBean.getText("comalatech.migration.preflight.workflows.check.warning.paragraph2") + "</><unordered-item>" + this.comalaI18nBean.getText("comalatech.migration.preflight.workflows.check.warning.orderedItem2") + "</><unordered-item>" + this.comalaI18nBean.getText("comalatech.migration.preflight.workflows.check.warning.orderedItem3") + "</><paragraph>" + this.comalaI18nBean.getText("comalatech.migration.preflight.workflows.check.warning.paragraph3"));
        stepsToResolve.put(STEPS_TO_RESOLVE_WORKFLOWS_ASSESSMENT_ERROR, "<paragraph>" + this.comalaI18nBean.getText("comalatech.migration.preflight.workflows.check.error.paragraph") + "</>");
        return stepsToResolve;
    }

    private String getBaseUrlWithoutScheme() {
        String domainName = this.globalSettingsManager.getGlobalSettings().getBaseUrl();
        try {
            URI uri = new URI(domainName);
            String authority = uri.getAuthority();
            String path = uri.getRawPath();
            return authority + (path != null ? path : "");
        }
        catch (URISyntaxException e) {
            return domainName;
        }
    }
}

