/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.mappers.cloud;

import com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationNamesSpaces;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.license.WorkflowsFeatureManagerImpl;
import java.util.Map;

public abstract class ActivityCloudUserMapper {
    private final WorkflowsFeatureManager workflowsFeatureManager;

    public ActivityCloudUserMapper(WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    public abstract Activity map(Activity var1, Map<String, String> var2);

    public abstract boolean shouldApply(Activity var1);

    protected String getAccountUserId(String serverId, Map<String, String> userMapping) {
        if (serverId == null || serverId.isEmpty()) {
            return "";
        }
        if (userMapping.containsKey(MigrationNamesSpaces.USERS_KEY_PREFIX + serverId)) {
            return userMapping.get(MigrationNamesSpaces.USERS_KEY_PREFIX + serverId);
        }
        if (WorkflowsFeatureManagerImpl.isWorkflowsUser(serverId)) {
            return this.workflowsFeatureManager.getPluginKey();
        }
        if ("com.comalatech.anonymous".equals(serverId)) {
            return "com.comalatech.anonymous";
        }
        return "com.comalatech.deleted";
    }
}

