/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.mappers;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.Actor;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.State;
import com.comalatech.confluence.cloud.migration.usecases.mappers.ActivityMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.ActorMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.ApprovalsMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.activity.approval.ApprovalApprovedMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.activity.approval.ApprovalAssignedMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.activity.approval.ApprovalRejectedMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.activity.approval.ApprovalUnassignedMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.activity.state.StateDueDateMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.activity.state.StateTransitionMapper;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.util.FancyDateFormatter;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.model.DecoratedApprovalCheck;
import com.comalatech.workflow.StateService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMapper {
    private static final Logger log = LoggerFactory.getLogger(StateMapper.class);
    private final ActorMapper actorMapper = Mappers.getMapper(ActorMapper.class);
    private final WorkflowAccessor workflowAccessor;
    private final ApprovalManager approvalManager;
    private final StateService stateService;
    final List<ActivityMapper> mappers = new ArrayList<ActivityMapper>();
    private final ApprovalsMapper approvalsMapper;

    public StateMapper(WorkflowAccessor workflowAccessor, ApprovalManager approvalManager, StateService stateService, UserAccessor userAccessor) {
        this.workflowAccessor = workflowAccessor;
        this.approvalManager = approvalManager;
        this.stateService = stateService;
        this.approvalsMapper = new ApprovalsMapper(userAccessor);
        this.mappers.add(new StateTransitionMapper());
        this.mappers.add(new StateDueDateMapper());
        this.mappers.add(new ApprovalAssignedMapper());
        this.mappers.add(new ApprovalUnassignedMapper());
        this.mappers.add(new ApprovalApprovedMapper());
        this.mappers.add(new ApprovalRejectedMapper());
    }

    public State map(AbstractPage content, List<Activity> activities) {
        com.comalatech.workflow.model.State publishedState;
        List<DecoratedApprovalCheck> approvalChecks;
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(content);
        List<Object> approvals = Collections.synchronizedList(new ArrayList());
        if (activities == null || activities.isEmpty()) {
            return null;
        }
        if (pageWorkflows != null && (approvalChecks = this.approvalManager.getDecoratedApprovalChecks(pageWorkflows, true, false)) != null) {
            approvals = approvalChecks.stream().map(this.approvalsMapper::map).filter(Objects::nonNull).collect(Collectors.toList());
        }
        State state = activities.stream().filter(this::isStateTransitionActivity).map(this::map).findFirst().orElse(new State());
        activities.stream().filter(act -> ActionType.Type.STATE.equals((Object)act.getAction().getActionType().type) && ActionType.Subtype.STATE_EXPIRY_UPDATE.equals((Object)act.getAction().getActionType().subtype)).reduce((first, second) -> second).ifPresent(stateDueDateActivity -> state.setExpires(FancyDateFormatter.convertEpochToFormattedDate(Long.parseLong(stateDueDateActivity.getAction().getActionDetails().getDetail(ActionDetailType.NEW_EXPIRY_DATE).getValue()), "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")));
        if (!approvals.isEmpty()) {
            state.setApprovals(approvals);
            state.setApprovers(approvals.stream().filter(approval -> approval.getApprovers() != null && !approval.getApprovers().isEmpty()).flatMap(approval -> approval.getApprovers().stream()).collect(Collectors.toList()));
        }
        if ((publishedState = this.stateService.getPublishedState((ContentEntityObject)content)) != null) {
            state.setApprovedVersion(publishedState.getContentVersion());
        }
        List<com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity> stateActivities = activities.stream().map(this::applyMappers).filter(Objects::nonNull).sorted(Comparator.comparing(com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity::getTimestamp)).collect(Collectors.toList());
        state.setActivities(stateActivities);
        List<? extends com.comalatech.workflow.model.State> states = this.stateService.getStates((ContentEntityObject)content);
        state.setVisitedStates(states.stream().map(PageState::getName).collect(Collectors.toSet()));
        return state;
    }

    private boolean isStateTransitionActivity(Activity activity) {
        return ActionType.Type.STATE.equals((Object)activity.getAction().getActionType().type) && (ActionType.Subtype.STATE_TRANSITION.equals((Object)activity.getAction().getActionType().subtype) || ActionType.Subtype.STATE_INIT.equals((Object)activity.getAction().getActionType().subtype) || ActionType.Subtype.STATE_OVERRIDE.equals((Object)activity.getAction().getActionType().subtype));
    }

    private State map(Activity activity) {
        State state = new State();
        if (activity == null) {
            return state;
        }
        state.setContentId(String.valueOf(activity.getTarget().getTargetId()));
        state.setContentVersion(activity.getTarget().getTargetVersion());
        state.setName(activity.getAction().getActionDetails().getDetail(ActionDetailType.STATE_NAME).getValue());
        state.setFinal(Boolean.parseBoolean(activity.getAction().getActionDetails().getDetail(ActionDetailType.IS_PUBLISHED).getValue()));
        String colour = activity.getAction().getActionDetails().getDetail(ActionDetailType.STATE_COLOUR).getValue();
        if (colour != null) {
            state.setColour(colour);
        }
        state.setComment(activity.getAction().getActionDetails().getDetail(ActionDetailType.STATE_COMMENT).getValue());
        state.setUser(this.actorListToPerformer(activity.getAction().getActors()));
        return state;
    }

    private Actor actorListToPerformer(List<com.comalatech.confluence.documentActivity.domain.entities.Actor> list) {
        if (list == null) {
            return null;
        }
        Actor actor = null;
        if (!list.isEmpty()) {
            actor = this.actorMapper.pageActivityActorToMigrationActivityActor(list.get(0));
        }
        return actor;
    }

    private com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity applyMappers(Activity activity) {
        ActivityMapper actMapper = this.mappers.stream().filter(mapper -> mapper.shouldApply(activity)).findFirst().orElse(null);
        if (actMapper == null) {
            return null;
        }
        return actMapper.map(activity);
    }
}

