/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.infrastructure;

import com.comalatech.confluence.cloud.migration.entity.domain.activity.Actor;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.State;
import com.comalatech.confluence.cloud.migration.usecases.contracts.Presenter;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jacksonMixins.MigrationActorMixin;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jacksonMixins.MigrationStateMixin;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="fileJsonPresenter")
public class FileJsonPresenter
implements Presenter<File> {
    private static final Logger log = LoggerFactory.getLogger(FileJsonPresenter.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public FileJsonPresenter() {
        this.mapper.addMixIn(Actor.class, MigrationActorMixin.class);
        this.mapper.addMixIn(State.class, MigrationStateMixin.class);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public <U> File present(List<U> elements) {
        File file;
        File result = File.createTempFile("migration", "activities");
        FileOutputStream file2 = new FileOutputStream(result);
        try {
            this.mapper.writeValue(file2, elements);
            file = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)file2).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Error serializing data {}", elements, (Object)e);
                return null;
            }
        }
        ((OutputStream)file2).close();
        return file;
    }

    @Override
    public <U> File present(U element) {
        File file;
        File result = File.createTempFile("migration", "activities");
        FileOutputStream file2 = new FileOutputStream(result);
        try {
            this.mapper.writeValue(file2, element);
            file = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)file2).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Error serializing data {}", element, (Object)e);
                return null;
            }
        }
        ((OutputStream)file2).close();
        return file;
    }
}

