/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.usecases.CloudMappings;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudMappingsData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationNamesSpaces;
import com.comalatech.confluence.translator.application.ServerWorkflowCommand;
import com.comalatech.confluence.translator.domain.WorkflowTranslator;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.workflow.model.WorkflowParameter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class WorkflowMigrationHelper {
    private static final Logger log = LoggerFactory.getLogger(WorkflowMigrationHelper.class);
    private static final String USER = "user";
    private static final String GROUP = "group";
    private static final String WP_DEFAULT_VALUE = "defaultValue";
    private final UserAccessor userAccessor;
    private final CloudMappingsData cloudMappingsData;
    private final WorkflowMarkupManager workflowMarkupManager;
    private final WorkflowTranslator workflowTranslator;
    private final CloudPopulationData<String> userPopulationData;
    private final CloudPopulationData<String> groupPopulationData;
    private String transferId;
    private ProcessMode mode;
    private AppCloudMigrationGateway gateway;

    public WorkflowMigrationHelper(@ComponentImport UserAccessor userAccessor, CloudMappingsData cloudMappingsData, WorkflowMarkupManager workflowMarkupManager, WorkflowTranslator workflowTranslator, @Qualifier(value="cloudWorkflowUserIdPopulationUseCase") CloudPopulationData<String> userPopulationData, @Qualifier(value="cloudWorkflowGroupIdPopulationUseCase") CloudPopulationData<String> groupPopulationData) {
        this.userAccessor = userAccessor;
        this.cloudMappingsData = cloudMappingsData;
        this.workflowMarkupManager = workflowMarkupManager;
        this.workflowTranslator = workflowTranslator;
        this.userPopulationData = userPopulationData;
        this.groupPopulationData = groupPopulationData;
    }

    public void setExecutionDetails(AppCloudMigrationGateway gateway, String transferId, ProcessMode mode) {
        this.gateway = gateway;
        this.transferId = transferId;
        this.mode = mode;
    }

    public void extractApprovals(JsonNode stateNode, HashSet<String> usersID, HashSet<String> groupID) {
        JsonNode approvals = stateNode.get("approvals");
        if (Objects.isNull(approvals) || !approvals.isArray()) {
            return;
        }
        approvals.forEach(approvalNode -> {
            JsonNode preassignedGroups;
            JsonNode preassignedUsers;
            JsonNode jsonNode = preassignedUsers = Objects.nonNull(approvalNode.get("preassignedUsers")) ? approvalNode.get("preassignedUsers").get("items") : null;
            if (Objects.nonNull(preassignedUsers) && preassignedUsers.isArray()) {
                for (JsonNode preassignedUser : preassignedUsers) {
                    ConfluenceUser user;
                    if (preassignedUser.asText().contains("@") || !Objects.nonNull(user = this.userAccessor.getUserByName(preassignedUser.asText()))) continue;
                    usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + user.getKey().getStringValue());
                }
            }
            JsonNode jsonNode2 = preassignedGroups = Objects.nonNull(approvalNode.get("preassignedGroups")) ? approvalNode.get("preassignedGroups").get("items") : null;
            if (Objects.nonNull(preassignedGroups) && preassignedGroups.isArray()) {
                for (JsonNode preassignedGroup : preassignedGroups) {
                    if (preassignedGroup.asText().contains("@")) continue;
                    groupID.add(MigrationNamesSpaces.GROUP_NAME_PREFIX + preassignedGroup.asText());
                }
            }
        });
    }

    public void extractParameters(JsonNode rootNode, HashSet<String> usersID, HashSet<String> groupID) {
        JsonNode parameters = rootNode.get("parameters");
        if (Objects.isNull(parameters) || !parameters.isArray()) {
            return;
        }
        for (JsonNode parameter : parameters) {
            String[] values;
            JsonNode value = parameter.get(WP_DEFAULT_VALUE);
            if (value == null || value.asText().contains("@")) continue;
            for (String rawValue : values = value.asText().split(",")) {
                String trimmedValue = rawValue.trim();
                if (trimmedValue.contains("@")) continue;
                String type = parameter.get("type").asText();
                if (USER.equals(type)) {
                    ConfluenceUser user = this.userAccessor.getUserByName(trimmedValue);
                    if (user == null) continue;
                    usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + user.getKey().getStringValue());
                    continue;
                }
                if (!GROUP.equals(type)) continue;
                groupID.add(MigrationNamesSpaces.GROUP_NAME_PREFIX + trimmedValue);
            }
        }
    }

    public void extractActions(JsonNode triggerNode, HashSet<String> usersID, HashSet<String> groupID) {
        JsonNode actions = triggerNode.get("actions");
        if (Objects.isNull(actions) || !actions.isArray()) {
            return;
        }
        actions.forEach(actionNode -> {
            JsonNode userOrGroupRestrictions;
            JsonNode recipients;
            if (actionNode.get("action").asText().equals("send-email") && Objects.nonNull(recipients = actionNode.get("recipients"))) {
                for (JsonNode recipient : recipients) {
                    ConfluenceUser user;
                    if (Objects.nonNull(recipient.get(USER)) && !recipient.get(USER).asText().contains("@") && Objects.nonNull(user = this.userAccessor.getUserByName(recipient.get(USER).asText()))) {
                        usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + user.getKey().getStringValue());
                    }
                    if (!Objects.nonNull(recipient.get(GROUP)) || recipient.get(GROUP).asText().contains("@")) continue;
                    groupID.add(MigrationNamesSpaces.GROUP_NAME_PREFIX + recipient.get(GROUP).asText());
                }
            }
            if ((actionNode.get("action").asText().equals("set-restrictions") || actionNode.get("action").asText().equals("add-restrictions")) && Objects.nonNull(userOrGroupRestrictions = actionNode.get("restrictions"))) {
                for (JsonNode userOrGroupRestriction : userOrGroupRestrictions) {
                    String restriction;
                    if (Objects.nonNull(userOrGroupRestriction.get(USER))) {
                        ArrayNode userRestrictions = (ArrayNode)userOrGroupRestriction.get(USER);
                        for (JsonNode userRestriction : userRestrictions) {
                            ConfluenceUser user;
                            restriction = userRestriction.asText();
                            if (!Objects.nonNull(restriction) || restriction.contains("@") || !Objects.nonNull(user = this.userAccessor.getUserByName(restriction))) continue;
                            usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + user.getKey().getStringValue());
                        }
                    }
                    if (!Objects.nonNull(userOrGroupRestriction.get(GROUP))) continue;
                    ArrayNode groupRestrictions = (ArrayNode)userOrGroupRestriction.get(GROUP);
                    for (JsonNode groupRestriction : groupRestrictions) {
                        restriction = groupRestriction.asText();
                        if (!Objects.nonNull(restriction) || restriction.contains("@")) continue;
                        groupID.add(MigrationNamesSpaces.GROUP_NAME_PREFIX + restriction);
                    }
                }
            }
        });
    }

    public CloudMappings getCloudMappings(HashSet<String> usersIds, HashSet<String> groupIds) {
        CloudMappings mappings = new CloudMappings();
        if (ProcessMode.MIGRATION.equals((Object)this.mode)) {
            mappings.setUserMappings(this.cloudMappingsData.getCloudMappings(this.gateway, this.transferId, MigrationNamesSpaces.USERS_KEY.toString(), usersIds));
            mappings.setGroupMappings(this.cloudMappingsData.getCloudMappings(this.gateway, this.transferId, MigrationNamesSpaces.CONFLUENCE_GROUP.toString(), groupIds));
        }
        return mappings;
    }

    public Map<String, String> mapWorkflowParametersCloudIds(List<WorkflowParameter> workflowParameters) {
        HashSet<String> groupIds = new HashSet<String>();
        HashSet<String> usersIds = new HashSet<String>();
        for (WorkflowParameter wp : workflowParameters) {
            String[] values;
            if (wp.getValue() == null) continue;
            block10: for (String value : values = wp.getValue().split(",")) {
                String trimmed = value.trim();
                switch (wp.getType()) {
                    case USER: {
                        ConfluenceUser user = this.userAccessor.getUserByName(trimmed);
                        if (user == null) continue block10;
                        usersIds.add(MigrationNamesSpaces.USERS_KEY_PREFIX + user.getKey().getStringValue());
                        continue block10;
                    }
                    case GROUP: {
                        groupIds.add(MigrationNamesSpaces.GROUP_NAME_PREFIX + trimmed);
                        continue block10;
                    }
                }
            }
        }
        CloudMappings mappings = this.getCloudMappings(usersIds, groupIds);
        for (WorkflowParameter wp : workflowParameters) {
            if (wp.getValue() == null) continue;
            String[] values = wp.getValue().split(",");
            ArrayList<String> mappedValues = new ArrayList<String>();
            switch (wp.getType()) {
                case USER: {
                    String trimmed;
                    for (String value : values) {
                        trimmed = value.trim();
                        ConfluenceUser user = this.userAccessor.getUserByName(trimmed);
                        if (user != null) {
                            String key = MigrationNamesSpaces.USERS_KEY_PREFIX + user.getKey().getStringValue();
                            String mapped = mappings.getUserMappings().get(key);
                            mappedValues.add(Objects.requireNonNullElse(mapped, trimmed));
                            continue;
                        }
                        mappedValues.add(trimmed);
                    }
                    break;
                }
                case GROUP: {
                    String trimmed;
                    for (String value : values) {
                        trimmed = value.trim();
                        String key = MigrationNamesSpaces.GROUP_NAME_PREFIX + trimmed;
                        String mapped = mappings.getGroupMappings().get(key);
                        mappedValues.add(Objects.requireNonNullElse(mapped, trimmed));
                    }
                    break;
                }
                case DURATION: 
                case STRING: 
                case LIST: {
                    String value = values[0].trim();
                    mappedValues.add(value);
                    break;
                }
            }
            wp.setValue(String.join((CharSequence)",", mappedValues));
        }
        return workflowParameters.stream().collect(Collectors.toMap(WorkflowParameter::getName, WorkflowParameter::getValue));
    }

    public String mapWorkflowCloudIds(String cloudWorkflowMarkup) throws JsonProcessingException {
        JsonNode triggersNode;
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        HashSet<String> groupIds = new HashSet<String>();
        HashSet<String> usersIds = new HashSet<String>();
        JsonNode rootNode = objectMapper.readTree(cloudWorkflowMarkup);
        this.extractParameters(rootNode, usersIds, groupIds);
        JsonNode statesNode = rootNode.get("states");
        if (!Objects.isNull(statesNode) && statesNode.isArray()) {
            statesNode.forEach(stateNode -> this.extractApprovals((JsonNode)stateNode, usersIds, groupIds));
        }
        if (!Objects.isNull(triggersNode = rootNode.get("triggers")) && triggersNode.isArray()) {
            triggersNode.forEach(triggerNode -> this.extractActions((JsonNode)triggerNode, usersIds, groupIds));
        }
        CloudMappings mappings = this.getCloudMappings(usersIds, groupIds);
        cloudWorkflowMarkup = this.userPopulationData.populateCloudData(cloudWorkflowMarkup, mappings.getUserMappings());
        cloudWorkflowMarkup = this.groupPopulationData.populateCloudData(cloudWorkflowMarkup, mappings.getGroupMappings());
        return cloudWorkflowMarkup;
    }

    public String getCloudWorkflowMarkup(com.comalatech.workflow.model.Workflow workflow) {
        String jsonWorkflowString = this.workflowMarkupManager.convertToJson((Workflow)workflow);
        return new JSONObject(this.workflowTranslator.handle(ServerWorkflowCommand.builder().workflow(new JSONObject(jsonWorkflowString).toMap()).build())).get("workflow").toString();
    }

    public String getUpdatedMarkup(com.comalatech.workflow.model.Workflow workflow) {
        String cloudWorkflowMarkup = this.getCloudWorkflowMarkup(workflow);
        switch (this.mode) {
            case MIGRATION: {
                try {
                    return this.mapWorkflowCloudIds(cloudWorkflowMarkup);
                }
                catch (Exception e) {
                    log.error("Error processing cloud json: {}", (Object)e.getMessage(), (Object)e);
                    throw new RuntimeException(e);
                }
            }
            case DEBUG: {
                return cloudWorkflowMarkup;
            }
        }
        return null;
    }

    public Map<String, String> getMappedParameters(List<WorkflowParameter> workflowParameters) {
        switch (this.mode) {
            case MIGRATION: {
                return this.mapWorkflowParametersCloudIds(workflowParameters);
            }
            case DEBUG: {
                return workflowParameters.stream().collect(Collectors.toMap(WorkflowParameter::getName, WorkflowParameter::getValue));
            }
        }
        return null;
    }

    public static enum ProcessMode {
        MIGRATION,
        DEBUG;

    }
}

