/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.entity.domain.metadata.Metadata;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageMetadataMigrationData;
import com.comalatech.confluence.cloud.migration.usecases.repository.MetadataRepository;
import com.comalatech.confluence.cloud.migration.usecases.repository.entity.MetadataRecord;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.model.PageWorkflowParameter;
import com.comalatech.confluence.workflow.model.PageWorkflowParameters;
import com.comalatech.confluence.workflow.model.WorkflowParameter;
import com.comalatech.workflow.model.WorkflowParameterType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GeneratePageMetadataUseCase
implements GeneratePageMetadataMigrationData {
    private static final Logger log = LoggerFactory.getLogger(GeneratePageMetadataUseCase.class);
    private final SpaceManager spaceManager;
    private final PageManager pageManager;
    private final MetadataRepository metadataRepository;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final WorkflowAccessor workflowAccessor;
    private final InternalWorkflowParameterManager internalWorkflowParameterManager;
    private static final String METADATA_PREFIX = "metadata.";

    public GeneratePageMetadataUseCase(@ComponentImport SpaceManager spaceManager, MetadataRepository metadataRepository, ReadWriteTransactionService readWriteTransactionService, PageManager pageManager, WorkflowAccessor workflowAccessor, InternalWorkflowParameterManager internalWorkflowParameterManager) {
        this.spaceManager = spaceManager;
        this.metadataRepository = metadataRepository;
        this.readWriteTransactionService = readWriteTransactionService;
        this.pageManager = pageManager;
        this.workflowAccessor = workflowAccessor;
        this.internalWorkflowParameterManager = internalWorkflowParameterManager;
    }

    @Override
    public Map<AbstractPage, List<Metadata>> generatePageMetadata(String spaceKey, boolean setWorkflowParameters, boolean hasWorkflows) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            log.warn("No space found to retrieve the content metadata for the space key {}", (Object)spaceKey);
            return null;
        }
        List<Metadata> metadata = this.readWriteTransactionService.executeInReadOnlyTransaction(() -> {
            List<MetadataRecord> records = this.metadataRepository.findAllMetadataBySpace(space);
            ArrayList _metadata = new ArrayList();
            records.forEach(record -> _metadata.add(new Metadata(record.getContentId(), record.getKey().substring(METADATA_PREFIX.length()), record.getValue(), null)));
            return _metadata;
        });
        if (metadata == null) {
            metadata = Collections.emptyList();
        }
        Map<AbstractPage, List<Metadata>> metadataByContent = this.groupMetadataByContent(metadata);
        if (hasWorkflows && setWorkflowParameters) {
            this.processWorkflowParameters(metadataByContent);
        }
        return metadataByContent;
    }

    private Map<AbstractPage, List<Metadata>> groupMetadataByContent(List<Metadata> metadata) {
        return metadata.stream().filter(m -> this.pageManager.getAbstractPage(m.getContentId().longValue()) != null).collect(Collectors.groupingBy(m -> this.pageManager.getAbstractPage(m.getContentId().longValue()), LinkedHashMap::new, Collectors.toList()));
    }

    private void processWorkflowParameters(Map<AbstractPage, List<Metadata>> metadataByContent) {
        metadataByContent.forEach((page, metadataList) -> {
            if (page == null) {
                return;
            }
            PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows((AbstractPage)page);
            if (pageWorkflows == null) {
                return;
            }
            PageWorkflowParameters parameters = this.internalWorkflowParameterManager.getPageWorkflowParameters(pageWorkflows);
            if (parameters == null || parameters.isEmpty()) {
                return;
            }
            Map<String, PageWorkflowParameter> editableParametersByName = parameters.stream().filter(WorkflowParameter::isPageEditable).collect(Collectors.toMap(WorkflowParameter::getName, parameter -> parameter, (p1, p2) -> p1));
            metadataList.forEach(metadataItem -> {
                PageWorkflowParameter editableParameter;
                if (editableParametersByName.containsKey(metadataItem.getName()) && (editableParameter = (PageWorkflowParameter)editableParametersByName.get(metadataItem.getName())) != null) {
                    if (WorkflowParameterType.GROUP.equals((Object)editableParameter.getType())) {
                        metadataItem.setType(Metadata.ContentType.WORKFLOW_PARAMETER_GROUP);
                    } else if (WorkflowParameterType.USER.equals((Object)editableParameter.getType())) {
                        metadataItem.setType(Metadata.ContentType.WORKFLOW_PARAMETER_USER);
                    }
                }
            });
        });
    }
}

