/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationNamesSpaces;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="cloudWorkflowGroupIdPopulationUseCase")
public class CloudWorkflowGroupIdPopulationUseCase
implements CloudPopulationData<String> {
    private static final Logger log = LoggerFactory.getLogger(CloudWorkflowGroupIdPopulationUseCase.class);
    private static final String GROUP = "group";
    private static final String WP_DEFAULT_VALUE = "defaultValue";
    private final ObjectMapper objectMapper = new ObjectMapper();

    public CloudWorkflowGroupIdPopulationUseCase() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public String populateCloudData(String cloudWorkflow, Map<String, String> contentMapping) {
        ObjectNode rootNode;
        if (contentMapping.isEmpty()) {
            return cloudWorkflow;
        }
        try {
            JsonNode triggersNode;
            rootNode = (ObjectNode)this.objectMapper.readTree(cloudWorkflow);
            this.mapParameterCloudIds(contentMapping, rootNode);
            ArrayNode statesNode = (ArrayNode)rootNode.get("states");
            if (!Objects.isNull(statesNode) && statesNode.isArray()) {
                statesNode.forEach(stateNode -> this.mapApprovalsCloudIds(contentMapping, (JsonNode)stateNode));
            }
            if (!Objects.isNull(triggersNode = rootNode.get("triggers")) && triggersNode.isArray()) {
                triggersNode.forEach(triggerNode -> this.mapActionsCloudIds(contentMapping, (JsonNode)triggerNode));
            }
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return rootNode.toString();
    }

    private void mapParameterCloudIds(Map<String, String> groupMapping, JsonNode workflowMarkupNode) {
        JsonNode parameters = workflowMarkupNode.get("parameters");
        if (Objects.isNull(parameters) || !parameters.isArray()) {
            return;
        }
        for (JsonNode parameter : parameters) {
            if (!GROUP.equals(parameter.get("type").asText())) continue;
            ObjectNode parameterObject = (ObjectNode)parameter;
            TextNode valueNode = (TextNode)parameter.get(WP_DEFAULT_VALUE);
            if (valueNode == null) continue;
            String[] groupIds = valueNode.asText().split(",");
            String cloudGroupIds = Arrays.stream(groupIds).filter(Objects::nonNull).map(String::trim).map(group -> {
                String mappedGroup = (String)groupMapping.get(MigrationNamesSpaces.GROUP_NAME_PREFIX + group);
                return mappedGroup != null ? mappedGroup : group;
            }).collect(Collectors.joining(","));
            parameterObject.put(WP_DEFAULT_VALUE, cloudGroupIds);
        }
    }

    private void mapApprovalsCloudIds(Map<String, String> groupMapping, JsonNode stateNode) {
        JsonNode approvals = stateNode.get("approvals");
        if (Objects.isNull(approvals) || !approvals.isArray()) {
            return;
        }
        approvals.forEach(approvalNode -> {
            ArrayNode preassignedGroups;
            ArrayNode arrayNode = preassignedGroups = Objects.nonNull(approvalNode.get("preassignedGroups")) ? (ArrayNode)approvalNode.get("preassignedGroups").get("items") : null;
            if (Objects.nonNull(preassignedGroups) && preassignedGroups.isArray()) {
                for (int i = 0; i < preassignedGroups.size(); ++i) {
                    String value = preassignedGroups.get(i).asText();
                    String group = (String)groupMapping.get(MigrationNamesSpaces.GROUP_NAME_PREFIX + value);
                    if (!Objects.nonNull(group)) continue;
                    preassignedGroups.set(i, group);
                }
            }
        });
    }

    private void mapActionsCloudIds(Map<String, String> groupMapping, JsonNode triggerNode) {
        JsonNode actions = triggerNode.get("actions");
        if (Objects.isNull(actions) || !actions.isArray()) {
            return;
        }
        for (JsonNode actionNode : actions) {
            switch (actionNode.get("action").asText()) {
                case "send-email": {
                    CloudWorkflowGroupIdPopulationUseCase.mapSendEmailAction(groupMapping, (ArrayNode)actionNode.get("recipients"));
                }
                case "add-restrictions": 
                case "set-restrictions": {
                    CloudWorkflowGroupIdPopulationUseCase.mapRestrictionActions(groupMapping, (ArrayNode)actionNode.get("restrictions"));
                }
            }
        }
    }

    private static void mapSendEmailAction(Map<String, String> groupMapping, ArrayNode recipients) {
        if (Objects.isNull(recipients)) {
            return;
        }
        for (int i = 0; i < recipients.size(); ++i) {
            String group;
            ObjectNode value;
            TextNode groupJsonNode;
            if (!(recipients.get(i) instanceof ObjectNode) || !Objects.nonNull(groupJsonNode = (TextNode)(value = (ObjectNode)recipients.get(i)).get(GROUP)) || !Objects.nonNull(group = groupMapping.get(MigrationNamesSpaces.GROUP_NAME_PREFIX + groupJsonNode.asText()))) continue;
            value.put(GROUP, group);
        }
    }

    private static void mapRestrictionActions(Map<String, String> groupMapping, ArrayNode restrictions) {
        int i;
        if (Objects.isNull(restrictions)) {
            return;
        }
        ArrayNode groups = null;
        for (i = 0; i < restrictions.size(); ++i) {
            if (!Objects.nonNull(restrictions.get(i).get(GROUP))) continue;
            groups = (ArrayNode)restrictions.get(i).get(GROUP);
        }
        if (Objects.isNull(groups)) {
            return;
        }
        for (i = 0; i < groups.size(); ++i) {
            String group = groupMapping.get(MigrationNamesSpaces.GROUP_NAME_PREFIX + groups.get(i).asText());
            if (!Objects.nonNull(group)) continue;
            groups.set(i, group);
        }
    }
}

