/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.Actor;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.State;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationNamesSpaces;
import com.comalatech.confluence.cloud.migration.usecases.mappers.cloud.ActivityCloudUserMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.cloud.ApprovalApprovedCloudMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.cloud.ApprovalAssignedCloudMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.cloud.ApprovalRejectedCloudMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.cloud.ApprovalUnassignedCloudMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.cloud.StateDueDateCloudMapper;
import com.comalatech.confluence.cloud.migration.usecases.mappers.cloud.StateTransitionCloudMapper;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.license.WorkflowsFeatureManagerImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="cloudPageActivityUserIdPopulationUseCase")
public class CloudPageActivityUserIdPopulationUseCase
implements CloudPopulationData<State> {
    private static final Logger log = LoggerFactory.getLogger(CloudPageActivityUserIdPopulationUseCase.class);
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final List<ActivityCloudUserMapper> mappers = new ArrayList<ActivityCloudUserMapper>();

    public CloudPageActivityUserIdPopulationUseCase(WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.mappers.add(new StateTransitionCloudMapper(workflowsFeatureManager));
        this.mappers.add(new StateDueDateCloudMapper(workflowsFeatureManager));
        this.mappers.add(new ApprovalAssignedCloudMapper(workflowsFeatureManager));
        this.mappers.add(new ApprovalUnassignedCloudMapper(workflowsFeatureManager));
        this.mappers.add(new ApprovalApprovedCloudMapper(workflowsFeatureManager));
        this.mappers.add(new ApprovalRejectedCloudMapper(workflowsFeatureManager));
    }

    @Override
    public State populateCloudData(State state, Map<String, String> userMapping) {
        Actor user = state.getUser();
        if (user == null || user.getServerId() == null) {
            log.error("There is no user for the given state {} of content {}", (Object)state.getName(), (Object)state.getContentId());
            return state;
        }
        user.setAccountId(this.getAccountUserId(user.getServerId(), userMapping));
        state.setUser(user);
        state.getActivities().forEach(act -> this.applyMappers((Activity)act, userMapping));
        List<String> approvers = state.getApprovers();
        if (approvers != null) {
            List<String> accountIdApprovers = approvers.stream().map(approver -> this.getAccountUserId(approver.trim(), userMapping)).collect(Collectors.toList());
            if (!accountIdApprovers.isEmpty()) {
                state.setApprovers(accountIdApprovers);
            }
        } else {
            log.debug("There are no approvers for the given state {} of content {}", (Object)state.getName(), (Object)state.getContentId());
        }
        return state;
    }

    private String getAccountUserId(String serverId, Map<String, String> userMapping) {
        if (userMapping.containsKey(MigrationNamesSpaces.USERS_KEY_PREFIX + serverId)) {
            return userMapping.get(MigrationNamesSpaces.USERS_KEY_PREFIX + serverId);
        }
        if (WorkflowsFeatureManagerImpl.isWorkflowsUser(serverId)) {
            return this.workflowsFeatureManager.getPluginKey();
        }
        if ("com.comalatech.anonymous".equals(serverId)) {
            return "com.comalatech.anonymous";
        }
        return "com.comalatech.deleted";
    }

    private void applyMappers(Activity activity, Map<String, String> userMapping) {
        ActivityCloudUserMapper cloudUserMapper = this.mappers.stream().filter(mapper -> mapper.shouldApply(activity)).findFirst().orElse(null);
        if (cloudUserMapper == null) {
            return;
        }
        cloudUserMapper.map(activity, userMapping);
    }
}

