/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.comalatech.confluence.cloud.migration.entity.domain.migration.csvactivity.CsvActivity;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationNamesSpaces;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="cloudCsvActivityUserIdPopulationUseCase")
public class CloudCsvActivityUserIdPopulationUseCase
implements CloudPopulationData<CsvActivity> {
    private static final Logger log = LoggerFactory.getLogger(CloudCsvActivityUserIdPopulationUseCase.class);

    @Override
    public CsvActivity populateCloudData(CsvActivity csvActivity, Map<String, String> userMapping) {
        String user = csvActivity.getUser();
        if (user == null || user.isEmpty()) {
            log.error("There is no user associated with the csv activity entry");
            return csvActivity;
        }
        csvActivity.setUser(this.getAccountUserId(csvActivity.getUser(), userMapping));
        List<String> updatedContributors = csvActivity.getContributors().stream().map(contributor -> this.getAccountUserId((String)contributor, userMapping)).collect(Collectors.toList());
        csvActivity.setContributors(updatedContributors);
        CsvActivity.CsvActivityDescription csvActivityDescription = csvActivity.getDescription();
        List<String> descriptionUsers = csvActivity.getDescription().getUsers().stream().map(descriptionUser -> this.getAccountUserId((String)descriptionUser, userMapping)).collect(Collectors.toList());
        csvActivityDescription.setUsers(descriptionUsers);
        csvActivity.setDescription(csvActivityDescription);
        return csvActivity;
    }

    private String getAccountUserId(String serverUserId, Map<String, String> userMapping) {
        return userMapping.getOrDefault(MigrationNamesSpaces.USERS_KEY_PREFIX + serverUserId, serverUserId);
    }
}

