/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.tasks;

import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.comalatech.confluence.cloud.migration.service.DefaultCloudMigrationContentService;
import com.comalatech.confluence.cloud.migration.tasks.AttachActivityTaskRecord;
import com.comalatech.confluence.cloud.migration.tasks.MigrationTaskStatus;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachActivityTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(AttachActivityTask.class);
    private final String spaceKey;
    private final AttachActivityTaskRecord attachActivityTaskRecord;
    private final DefaultCloudMigrationContentService defaultCloudMigrationContentService;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final ComalaI18nBean i18nBean;
    private final List<Long> pageIds;
    private final boolean isPerSpace;

    public AttachActivityTask(String spaceKey, AttachActivityTaskRecord attachActivityTaskRecord, DefaultCloudMigrationContentService defaultCloudMigrationContentService, ReadWriteTransactionService readWriteTransactionService, ComalaI18nBean i18nBean, List<Long> pageIds, boolean perSpace) {
        this.spaceKey = spaceKey;
        this.attachActivityTaskRecord = attachActivityTaskRecord;
        this.defaultCloudMigrationContentService = defaultCloudMigrationContentService;
        this.readWriteTransactionService = readWriteTransactionService;
        this.i18nBean = i18nBean;
        this.pageIds = pageIds;
        this.isPerSpace = perSpace;
    }

    protected void runInternal() {
        try {
            this.attachActivityTaskRecord.setStartedTimestamp(new Date().getTime());
            this.attachActivityTaskRecord.setStatus(MigrationTaskStatus.IN_PROGRESS);
            this.defaultCloudMigrationContentService.setAttachActivityTaskStatus(this.spaceKey, this.attachActivityTaskRecord, this.isPerSpace);
            this.readWriteTransactionService.executeInReadWriteTransaction(() -> {
                log.debug("Starting long running task to attach activity csv to pages in space: {}", (Object)this.spaceKey);
                if (this.pageIds != null && !this.pageIds.isEmpty()) {
                    log.debug("Long running task set to IN PROGRESS for space: {}", (Object)this.spaceKey);
                    this.progress.setCurrentCount(0);
                    this.progress.setTotalObjects(this.pageIds.size());
                    try {
                        if (this.isPerSpace) {
                            this.attachCSVPerSpace(this.pageIds);
                        } else {
                            AtomicLong pagesProcessed = new AtomicLong(0L);
                            this.attachCSVPerPage(this.pageIds, pagesProcessed);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    log.debug("Long running task set to COMPLETED for space: {}", (Object)this.spaceKey);
                } else {
                    log.debug("No pages to process, setting long running task to COMPLETED for space: {}", (Object)this.spaceKey);
                }
                this.attachActivityTaskRecord.setStatus(MigrationTaskStatus.COMPLETED);
                this.attachActivityTaskRecord.setEndedTimestamp(new Date().getTime());
                return null;
            });
        }
        catch (Exception e) {
            this.attachActivityTaskRecord.setStatus(MigrationTaskStatus.FAIL);
            this.attachActivityTaskRecord.setEndedTimestamp(new Date().getTime());
            this.progress.setStatus(this.i18nBean.getText("awp.space.attachActivity.error"));
            this.progress.setCompletedSuccessfully(false);
            log.error("Error processing pages to attach activity as csv", (Throwable)e);
        }
        this.progress.setPercentage(100);
        this.progress.setCompletedSuccessfully(!MigrationTaskStatus.FAIL.equals((Object)this.attachActivityTaskRecord.getStatus()));
        this.defaultCloudMigrationContentService.setAttachActivityTaskStatus(this.spaceKey, this.attachActivityTaskRecord, this.isPerSpace);
    }

    private void attachCSVPerSpace(List<Long> pageIds) throws Exception {
        HashMap<Long, String> pageCsvFileList = new HashMap<Long, String>();
        pageIds.forEach(pageId -> {
            try {
                this.progress.setStatus(this.i18nBean.getText("awp.space.attachActivity.progress.status", new Object[]{String.valueOf(pageId)}));
                pageCsvFileList.put((Long)pageId, this.defaultCloudMigrationContentService.getPageCsv((Long)pageId));
            }
            catch (Exception e) {
                log.error("Error creating the csv to the page: {}", pageId);
                throw e;
            }
        });
        try {
            this.defaultCloudMigrationContentService.attachZipToHomePage(this.spaceKey, pageCsvFileList);
        }
        catch (Exception e) {
            log.error("Error creating the zip to the home page: {}", (Object)e.getMessage());
            throw new Exception(e.getMessage());
        }
    }

    private void attachCSVPerPage(List<Long> pageIds, AtomicLong pagesProcessed) {
        pageIds.forEach(pageId -> {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Attaching activity to page: {}", pageId);
                }
                this.progress.setStatus(this.i18nBean.getText("awp.space.attachActivity.progress.status", new Object[]{String.valueOf(pageId)}));
                this.defaultCloudMigrationContentService.attachCsvToPage((long)pageId);
            }
            catch (Exception e) {
                log.error("Error attaching the csv to the page: {}", pageId);
                throw e;
            }
            pagesProcessed.addAndGet(1L);
            this.progress.setPercentage(pagesProcessed.intValue(), pageIds.size());
        });
    }

    public String getName() {
        return this.i18nBean.getText("awp.space.attachActivity.task.name");
    }
}

