/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.support.model;

import com.comalatech.confluence.cloud.migration.model.mappings.ContentMapping;
import com.comalatech.confluence.util.CSVBuilder;
import com.comalatech.confluence.workflow.supportconsole.model.contract.SupportData;
import java.time.Instant;
import java.util.List;

public class MappingsCSVData
implements SupportData {
    private List<ContentMapping> mappings;
    private String fileName;
    private String migrationName;
    private String transferId;

    @Override
    public String getLogClassName() {
        return "migration mappings csv";
    }

    @Override
    public String getFilename() {
        return this.migrationName + "_" + this.transferId + "_" + Instant.now().toEpochMilli() + ".csv";
    }

    public String getMappingsIDs() {
        CSVBuilder csv = new CSVBuilder();
        this.getMappings().forEach(content -> {
            csv.addCell(content.getTitle());
            csv.addCell(content.getServerID());
            csv.addCell(content.getCloudID());
            csv.newLine();
        });
        return csv.get();
    }

    MappingsCSVData(List<ContentMapping> mappings, String fileName, String migrationName, String transferId) {
        this.mappings = mappings;
        this.fileName = fileName;
        this.migrationName = migrationName;
        this.transferId = transferId;
    }

    public static MappingsCSVDataBuilder builder() {
        return new MappingsCSVDataBuilder();
    }

    public List<ContentMapping> getMappings() {
        return this.mappings;
    }

    public String getMigrationName() {
        return this.migrationName;
    }

    public String getTransferId() {
        return this.transferId;
    }

    public void setMappings(List<ContentMapping> mappings) {
        this.mappings = mappings;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setMigrationName(String migrationName) {
        this.migrationName = migrationName;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MappingsCSVData)) {
            return false;
        }
        MappingsCSVData other = (MappingsCSVData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ContentMapping> this$mappings = this.getMappings();
        List<ContentMapping> other$mappings = other.getMappings();
        if (this$mappings == null ? other$mappings != null : !((Object)this$mappings).equals(other$mappings)) {
            return false;
        }
        String this$fileName = this.getFilename();
        String other$fileName = other.getFilename();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$migrationName = this.getMigrationName();
        String other$migrationName = other.getMigrationName();
        if (this$migrationName == null ? other$migrationName != null : !this$migrationName.equals(other$migrationName)) {
            return false;
        }
        String this$transferId = this.getTransferId();
        String other$transferId = other.getTransferId();
        return !(this$transferId == null ? other$transferId != null : !this$transferId.equals(other$transferId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MappingsCSVData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ContentMapping> $mappings = this.getMappings();
        result = result * 59 + ($mappings == null ? 43 : ((Object)$mappings).hashCode());
        String $fileName = this.getFilename();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $migrationName = this.getMigrationName();
        result = result * 59 + ($migrationName == null ? 43 : $migrationName.hashCode());
        String $transferId = this.getTransferId();
        result = result * 59 + ($transferId == null ? 43 : $transferId.hashCode());
        return result;
    }

    public String toString() {
        return "MappingsCSVData(mappings=" + this.getMappings() + ", fileName=" + this.getFilename() + ", migrationName=" + this.getMigrationName() + ", transferId=" + this.getTransferId() + ")";
    }

    public static class MappingsCSVDataBuilder {
        private List<ContentMapping> mappings;
        private String fileName;
        private String migrationName;
        private String transferId;

        MappingsCSVDataBuilder() {
        }

        public MappingsCSVDataBuilder mappings(List<ContentMapping> mappings) {
            this.mappings = mappings;
            return this;
        }

        public MappingsCSVDataBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public MappingsCSVDataBuilder migrationName(String migrationName) {
            this.migrationName = migrationName;
            return this;
        }

        public MappingsCSVDataBuilder transferId(String transferId) {
            this.transferId = transferId;
            return this;
        }

        public MappingsCSVData build() {
            return new MappingsCSVData(this.mappings, this.fileName, this.migrationName, this.transferId);
        }

        public String toString() {
            return "MappingsCSVData.MappingsCSVDataBuilder(mappings=" + this.mappings + ", fileName=" + this.fileName + ", migrationName=" + this.migrationName + ", transferId=" + this.transferId + ")";
        }
    }
}

