/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification.model;

import com.comalatech.confluence.adhoc.notification.model.Notification;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import org.springframework.web.util.HtmlUtils;

public class TaskNotification
extends Notification {
    protected static final String DEFAULT_TASK_TEMPLATE = "task-event";
    public static final String TASK_NAME_KEY = "taskName";
    public static final String TASK_ID_KEY = "taskId";
    public static final String ASSIGNEE_KEY = "assignee";
    public static final String COMPLETER_KEY = "completer";
    public static final String DUE_DATE_KEY = "dueDate";
    protected String subjectI18n;

    public TaskNotification(String subjectI18n) {
        this.subjectI18n = subjectI18n;
    }

    @Override
    public String getSubject() {
        return ComalaI18nBean.getComalaI18nBean().getText(this.subjectI18n, new String[]{HtmlUtils.htmlEscape((String)((String)this.getContextProperties().get(TASK_NAME_KEY)), (String)"UTF-8"), (String)this.getContextProperties().get(ASSIGNEE_KEY), (String)this.getContextProperties().get(COMPLETER_KEY)});
    }

    @Override
    public String getTemplateName() {
        return DEFAULT_TASK_TEMPLATE;
    }

    @Override
    public String getBody(Notification.MessageSystem notificationMessageSystem) {
        long pageId = this.getEntityId();
        String taskId = (String)this.getContextProperties().get(TASK_ID_KEY);
        String taskName = HtmlUtils.htmlEscape((String)((String)this.getContextProperties().get(TASK_NAME_KEY)));
        String assignee = (String)this.getContextProperties().get(ASSIGNEE_KEY);
        String dueDate = (String)this.getContextProperties().get(DUE_DATE_KEY);
        String path = this.getBaseUrl() + "/pages/viewpage.action?pageId=" + pageId + "&task=" + taskId;
        switch (notificationMessageSystem) {
            case EMAIL: {
                String description = (String)this.getContextProperties().get("activityDescription");
                return ComalaI18nBean.getComalaI18nBean().getText(description, new String[]{taskName, path, assignee, dueDate});
            }
            case SLACK: {
                String description = (String)this.getContextProperties().get("slackActivityDescription");
                return ComalaI18nBean.getComalaI18nBean().getText(description, new String[]{taskName, path, assignee, dueDate});
            }
        }
        throw new IllegalArgumentException("Type notification not valid");
    }
}

