/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.dao;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.dao.SpaceUIConfigDao;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflowreports.model.SpaceReportSettings;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultSpaceUIConfigDao
implements SpaceUIConfigDao {
    private static final Logger log = LoggerFactory.getLogger(DefaultSpaceUIConfigDao.class);
    private static final String SPACE_UI_CONFIG_PREFIX = ".spaceUIConfig.";
    private final BandanaManager bandanaManager;
    private final WorkflowsFeatureManager workflowsFeatureManager;

    public DefaultSpaceUIConfigDao(@ComponentImport BandanaManager bandanaManager, WorkflowsFeatureManager workflowsFeatureManager) {
        this.bandanaManager = bandanaManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    @Override
    public SpaceReportSettings getSpaceUIConfig(String spaceKey) {
        Object obj = this.bandanaManager.getValue(this.getBandanaContext(spaceKey), this.makeKey(spaceKey, this.workflowsFeatureManager.getPluginKey()));
        if (obj instanceof String) {
            SpaceReportSettings existingSpaceReportSettings = this.deserializeSpaceReportSettings((String)obj);
            if (existingSpaceReportSettings != null) {
                return new SpaceReportSettings(existingSpaceReportSettings.getSettings(), this.workflowsFeatureManager);
            }
        } else if (obj instanceof HashMap) {
            Map existingSettingsMap = (Map)obj;
            return new SpaceReportSettings(existingSettingsMap, this.workflowsFeatureManager);
        }
        return new SpaceReportSettings(this.workflowsFeatureManager);
    }

    @Override
    public void setSpaceUIConfig(String spaceKey, SpaceReportSettings settings) {
        this.bandanaManager.setValue(this.getBandanaContext(spaceKey), this.makeKey(spaceKey, this.workflowsFeatureManager.getPluginKey()), (Object)this.serializeSpaceReportSettings(settings));
    }

    private String makeKey(String spaceKey, String pluginKey) {
        return pluginKey + SPACE_UI_CONFIG_PREFIX + spaceKey;
    }

    private String serializeSpaceReportSettings(SpaceReportSettings data) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            return mapper.writeValueAsString(data);
        }
        catch (Exception e) {
            log.error("SpaceReportSettings could not be serialized", (Throwable)e);
            return null;
        }
    }

    private SpaceReportSettings deserializeSpaceReportSettings(String json) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            return mapper.readValue(json, SpaceReportSettings.class);
        }
        catch (IOException | NullPointerException e) {
            log.error("SpaceReportSettings could not be deserialized", (Throwable)e);
            return null;
        }
    }

    protected BandanaContext getBandanaContext(String spaceKey) {
        return new ConfluenceBandanaContext(spaceKey);
    }
}

