/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.action.condition;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhoc.action.condition.AbstractPageWorkflowCondition;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.model.State;
import java.util.Map;

public class HasWorkflowCondition
extends AbstractPageWorkflowCondition {
    protected final StateService stateService;
    protected final AdhocWorkflowsLicenseManager licenseManager;

    public HasWorkflowCondition(WorkflowContainerManager workflowContainerManager, AdhocWorkflowManager adhocWorkflowManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowPermissionManager workflowPermissionManager, StateService stateService, AdhocWorkflowsLicenseManager licenseManager) {
        super(workflowContainerManager, adhocWorkflowManager, workflowConfigurationManager, workflowPermissionManager);
        this.stateService = stateService;
        this.licenseManager = licenseManager;
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        AbstractPage page = this.getPage(context);
        if (page == null) {
            return false;
        }
        boolean hasPageWorkflow = this.adhocWorkflowManager.hasWorkflow(page);
        boolean hasSpaceWorkflow = this.workflowContainerManager.hasProductionWorkflows(page);
        boolean isLicensed = this.licenseManager.isLicensed();
        boolean hasPermissionToViewDrafts = this.workflowPermissionManager.canViewDrafts(page, AuthenticatedUserThreadLocal.get());
        State currentState = this.stateService.getCurrentState((ContentEntityObject)page);
        return hasPageWorkflow && hasPermissionToViewDrafts || hasPermissionToViewDrafts && hasSpaceWorkflow && currentState != null || hasSpaceWorkflow && !isLicensed;
    }
}

