/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhoc.PageWorkflowsConsolidationManager;
import com.comalatech.confluence.adhoc.task.PageWorkflowsConsolidationTask;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.model.AppliedPageWorkflow;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import com.comalatech.workflow.model.Workflow;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultPageWorkflowsConsolidationManager
implements PageWorkflowsConsolidationManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultPageWorkflowsConsolidationManager.class);
    private final LongRunningTaskManager longRunningTaskManager;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final AdhocWorkflowManager adhocWorkflowManager;
    private final PageManager pageManager;
    private final AccessModeService accessModeService;
    private final ComalaI18nBean comalaI18nBean;
    private final LabelManager labelManager;
    private final WorkflowService workflowService;

    public DefaultPageWorkflowsConsolidationManager(@ComponentImport LongRunningTaskManager longRunningTaskManager, ReadWriteTransactionService readWriteTransactionService, @ComponentImport PageManager pageManager, AdhocWorkflowManager adhocWorkflowManager, @ComponentImport AccessModeService accessModeService, ComalaI18nBean comalaI18nBean, LabelManager labelManager, WorkflowService workflowService) {
        this.longRunningTaskManager = longRunningTaskManager;
        this.readWriteTransactionService = readWriteTransactionService;
        this.pageManager = pageManager;
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.accessModeService = accessModeService;
        this.comalaI18nBean = comalaI18nBean;
        this.labelManager = labelManager;
        this.workflowService = workflowService;
    }

    @Override
    public LongRunningTaskId launchRemovePageWorkflows(String spaceKey, List<Long> contentIds, String workflowName, String markup) throws Exception {
        return this.startTask(spaceKey, contentIds, workflowName, markup, null);
    }

    @Override
    public LongRunningTaskId launchConsolidatePageWorkflows(String spaceKey, List<Long> contentIds, String workflowName, String markup, String label) throws Exception {
        return this.startTask(spaceKey, contentIds, workflowName, markup, label);
    }

    private LongRunningTaskId startTask(String spaceKey, List<Long> contentIds, String workflowName, String markup, String label) throws Exception {
        AppliedPageWorkflow.ConsolidationStatus status = this.adhocWorkflowManager.getConsolidationStatus(spaceKey, markup);
        if (status == AppliedPageWorkflow.ConsolidationStatus.IN_PROGRESS) {
            log.error("{} task status is In Progress", (Object)(label == null ? "Remove page workflows" : "Consolidation"));
            throw new Exception("Task already in progress. The task can not be run at this time");
        }
        List<Workflow> workflows = this.workflowService.getWorkflows(spaceKey);
        for (Workflow workflow : workflows) {
            if (!workflow.getLabelNames().contains(label)) continue;
            log.error("The label {} already exists in the space {} for the workflow {}", new Object[]{label, spaceKey, workflow.getName()});
            throw new RuntimeException("The label " + label + " is already in use in a workflow in the space");
        }
        PageWorkflowsConsolidationTask task = new PageWorkflowsConsolidationTask(this.readWriteTransactionService, this.adhocWorkflowManager, this.pageManager, this.accessModeService, this.comalaI18nBean, this.labelManager, this.workflowService, spaceKey, contentIds, workflowName, markup, label);
        return this.longRunningTaskManager.startLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), (LongRunningTask)task);
    }
}

