/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function (CW, $) {
    CW.toInit(function () {
        const GettingStartedIframe = new CW.iframe({
            id: 'GettingStartedIframe',
            url: '/gettingstarted',
            width: '100%',
            height: '100%',
            query: {
                spaceKey: CW.getParam('spaceKey')
            }
        });

        $('#cw-onboarding').html(GettingStartedIframe.render());
        $('#cw-onboarding').css({ 'height': '2300px' });
    })

    CW.connect("gettingStartedAddWorkflow", function ({ spaceKey, workflowType }) {
        const gettingStartedAddWorkflow = new CW.Dialog({
            id: 'cw-gettingStartedAddWorkflow',
            closeable: true,
            width: 574,
            height: 320,
            path: '/gettingstarted/addworkflow',
            query: {
                spaceKey, workflowType
            }
        });
        gettingStartedAddWorkflow.show();
    });
});