/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model;

import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.comalatech.confluence.util.pagination.PaginationSupport;
import com.comalatech.confluence.workflowreports.model.WorkflowReportEntry;
import com.comalatech.confluence.workflowreports.model.WorkflowReportOptions;
import com.comalatech.confluence.workflowreports.model.WorkflowReportSortEnum;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WorkflowReport {
    public static final String TYPE_STATES = "states";
    public static final String TYPE_APPROVALS = "approvals";
    public static final String TYPE_PAGE = "page";
    public static final String TYPE_DASHBOARD = "dashboard";
    public static final String TYPE_TASKS = "tasks";
    public static final String TYPE_STATS = "stats";
    private final WorkflowReportOptions options;
    private List<String> statesNames;
    private List<String> assignees;
    private List<?> approvals;
    private String currentStateName;
    private String currentApprovalName;
    private String currentFilter;
    private String currentAssignee;
    private List<WorkflowReportEntry> entries = Collections.emptyList();
    private final PaginationSupport paginationSupport;
    private String url;
    private final Map<String, String> params = new HashMap<String, String>();
    private int nextIndex;
    private boolean hasStates;
    private boolean hasDueDate;
    private boolean showPartialPagination;
    private final Map<String, Integer> statesCount;

    public WorkflowReport(WorkflowReportOptions options, PaginationSupport paginationSupport) {
        if (options.getSort() != WorkflowReportSortEnum.getDefault()) {
            if (options.getSort() == null) {
                this.params.put("sort", options.getSearchSort().getKey());
                this.params.put("order", options.getSearchSort().getOrder().toString().toLowerCase());
            } else {
                this.params.put("sort", options.getSort().getField());
                this.params.put("order", options.getSort().getOrder());
            }
        }
        this.paginationSupport = paginationSupport;
        this.options = options;
        this.nextIndex = -1;
        this.showPartialPagination = false;
        this.statesCount = new HashMap<String, Integer>();
    }

    public WorkflowReport(WorkflowReportOptions options) {
        this(options, options.getStateNames(), null);
    }

    public WorkflowReport(WorkflowReportOptions options, List<String> statesNames, PaginationSupport paginationSupport) {
        this(options, paginationSupport);
        this.statesNames = statesNames;
        this.hasStates = true;
    }

    public WorkflowReport(List<?> approvals, PaginationSupport paginationSupport, WorkflowReportOptions options) {
        this(options, paginationSupport);
        this.approvals = approvals;
        this.hasStates = false;
    }

    public void addStateCount(String state, int count) {
        this.statesCount.put(state, count);
    }

    public int getStateCount(String state) {
        try {
            return this.statesCount.get(state);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setCurrentStateName(String currentStateName) {
        if (currentStateName != null && !currentStateName.trim().isEmpty()) {
            this.params.put("state", currentStateName);
            this.currentStateName = currentStateName;
        }
    }

    public void setCurrentAssignee(String currentAssignee) {
        if (StringUtils.isNotBlank((CharSequence)currentAssignee)) {
            this.params.put("assignee", currentAssignee);
        }
        this.currentAssignee = currentAssignee;
    }

    public void setCurrentApprovalName(String currentApprovalName) {
        this.params.put("approval", currentApprovalName);
        this.currentApprovalName = currentApprovalName;
    }

    public void setCurrentFilter(String currentFilter) {
        this.params.put("filter", currentFilter);
        this.currentFilter = currentFilter;
    }

    public String sortOrder(String field) {
        if (this.options.getSort().getField().equals(field)) {
            return this.options.getSort().getReverseOrder();
        }
        return WorkflowReportSortEnum.makeSort(field, null).getOrder();
    }

    @HtmlSafe
    public String getUrl() {
        return this.getUrl(this.params);
    }

    public String getMoreUrl() {
        HashMap<String, String> newParams = new HashMap<String, String>(this.params);
        newParams.put("startIndex", Integer.toString(this.nextIndex));
        return this.getUrl(newParams);
    }

    public String getUrl(String key, String value) {
        HashMap<String, String> overriddenParams = new HashMap<String, String>(this.params);
        this.overrideParam(key, value, overriddenParams);
        return this.getUrl(overriddenParams);
    }

    public String getUrl(String key1, String value1, String key2, String value2) {
        HashMap<String, String> overriddenParams = new HashMap<String, String>(this.params);
        this.overrideParam(key1, value1, overriddenParams);
        this.overrideParam(key2, value2, overriddenParams);
        return this.getUrl(overriddenParams);
    }

    private void overrideParam(String key, String value, Map<String, String> overridenParams) {
        overridenParams.put(key, value);
    }

    public boolean isShowHeader() {
        return !this.options.isHideHeader();
    }

    public boolean isShowFilter() {
        return !this.options.isPending() || this.options.getUserName() == null;
    }

    private String getUrl(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.url)) {
            sb.append(this.url);
            if (this.url.contains("?")) {
                sb.append('&');
            } else {
                sb.append('?');
            }
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)entry.getValue())) continue;
                String value = HtmlUtil.urlEncode((String)entry.getValue());
                sb.append(entry.getKey()).append('=').append(value).append('&');
            }
        }
        return sb.toString();
    }

    public boolean isApproved() {
        return "approved".equalsIgnoreCase(this.currentFilter);
    }

    public boolean isPending() {
        return "pending".equalsIgnoreCase(this.currentFilter);
    }

    public boolean isRejected() {
        return "rejected".equalsIgnoreCase(this.currentFilter);
    }

    public WorkflowReportOptions getOptions() {
        return this.options;
    }

    public List<String> getStatesNames() {
        return this.statesNames;
    }

    public void setAssignees(List<String> assignees) {
        this.assignees = assignees;
    }

    public List<String> getAssignees() {
        return this.assignees;
    }

    public List<?> getApprovals() {
        return this.approvals;
    }

    public String getCurrentStateName() {
        return this.currentStateName;
    }

    public String getCurrentApprovalName() {
        return this.currentApprovalName;
    }

    public String getCurrentFilter() {
        return this.currentFilter;
    }

    public String getCurrentAssignee() {
        return this.currentAssignee;
    }

    public List<WorkflowReportEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<WorkflowReportEntry> entries) {
        this.entries = entries;
    }

    public PaginationSupport getPaginationSupport() {
        return this.paginationSupport;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setNextIndex(int nextIndex) {
        this.nextIndex = nextIndex;
    }

    public int getNextIndex() {
        return this.nextIndex;
    }

    public void setHasStates(boolean hasStates) {
        this.hasStates = hasStates;
    }

    public boolean isHasStates() {
        return this.hasStates;
    }

    public void setHasDueDate(boolean hasDueDate) {
        this.hasDueDate = hasDueDate;
    }

    public boolean isHasDueDate() {
        return this.hasDueDate;
    }

    public void setShowPartialPagination(boolean showPartialPagination) {
        this.showPartialPagination = showPartialPagination;
    }

    public boolean isShowPartialPagination() {
        return this.showPartialPagination;
    }
}

