/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.mappers;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ApprovalsReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import org.apache.commons.lang3.StringUtils;

public class UsernameParameterMapper
implements ParameterMapper {
    private final UserAccessor userAccessor;
    private static final String SELF = "@self";

    public UsernameParameterMapper(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public ReportParameter map(ReportParameter parameter) {
        if (this.parameterCanBeMapped(parameter)) {
            StringReportParameterValue value = (StringReportParameterValue)parameter.getValue();
            String username = value.getValueOrDefault();
            ConfluenceUser user = null;
            if (SELF.equals(username)) {
                user = AuthenticatedUserThreadLocal.get();
            } else if (StringUtils.isNotBlank((CharSequence)username)) {
                user = this.userAccessor.getUserByName(username);
            }
            String userKey = user != null ? user.getKey().getStringValue() : null;
            parameter.setValue(new StringReportParameterValue(userKey, (String)value.getDefaultValue()));
        }
        return parameter;
    }

    @Override
    public boolean parameterCanBeMapped(ReportParameter parameter) {
        return parameter.keyIs(ApprovalsReportParameters.ASSIGNEE.getKey()) && parameter.getValue() instanceof StringReportParameterValue;
    }
}

