/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.util.pagination.PaginationSupport;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.ValueStoreManager;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.confluence.workflow.model.DecoratedApprovalCheck;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflow.service.WorkflowSearchService;
import com.comalatech.confluence.workflowreports.TwoPointNineWorkflowReportCreator;
import com.comalatech.confluence.workflowreports.WorkflowReportCreator;
import com.comalatech.confluence.workflowreports.WorkflowReportManager;
import com.comalatech.confluence.workflowreports.model.TasksReportFilter;
import com.comalatech.confluence.workflowreports.model.WorkflowReport;
import com.comalatech.confluence.workflowreports.model.WorkflowReportEntry;
import com.comalatech.confluence.workflowreports.model.WorkflowReportOptions;
import com.comalatech.confluence.workflowreports.model.WorkflowReportSortEnum;
import com.comalatech.confluence.workflowreports.search.NamedSort;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.model.Assignment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.randombits.confluence.support.MacroInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultWorkflowReportManager
implements WorkflowReportManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowReportManager.class);
    private final WorkflowAccessor workflowAccessor;
    private final ApprovalAccessor approvalAccessor;
    private final ValueStoreManager valueStoreManager;
    private final ApprovalManager approvalManager;
    private final UserAccessor userAccessor;
    private final WorkflowSearchService workflowSearchService;
    private final WorkflowPermissionManager workflowPermissionManager;
    private final StateService stateService;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final PermissionManager permissionManager;
    private final AttachmentManager attachmentManager;
    private final WorkflowReportCreator workflowReportCreator;

    public DefaultWorkflowReportManager(WorkflowAccessor workflowAccessor, ApprovalAccessor approvalAccessor, ValueStoreManager valueStoreManager, ApprovalManager approvalManager, @ComponentImport UserAccessor userAccessor, WorkflowSearchService workflowSearchService, WorkflowPermissionManager workflowPermissionManager, StateService stateService, WorkflowsFeatureManager workflowsFeatureManager, @ComponentImport PermissionManager permissionManager, @ComponentImport AttachmentManager attachmentManager, TwoPointNineWorkflowReportCreator workflowReportCreator) {
        this.workflowAccessor = workflowAccessor;
        this.approvalAccessor = approvalAccessor;
        this.valueStoreManager = valueStoreManager;
        this.approvalManager = approvalManager;
        this.userAccessor = userAccessor;
        this.workflowSearchService = workflowSearchService;
        this.workflowPermissionManager = workflowPermissionManager;
        this.stateService = stateService;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.permissionManager = permissionManager;
        this.attachmentManager = attachmentManager;
        this.workflowReportCreator = workflowReportCreator;
    }

    @Override
    public WorkflowReport createReport(WorkflowReportOptions options, PaginationSupport<?> paginationSupport) {
        String order;
        String sort;
        String reportStates = options.getStateNameAsString();
        String filterStates = this.getRequestParam("state", reportStates);
        if (reportStates != null && reportStates.contains(filterStates) || filterStates == null) {
            sort = this.getRequestParam("sort", options.getSort().getField());
            order = this.getRequestParam("order", options.getSort().getOrder());
        } else {
            sort = options.getSort().getField();
            order = options.getSort().getOrder();
        }
        options.setSort(WorkflowReportSortEnum.makeSort(sort, order));
        if (options.isStatsReport()) {
            return this.workflowReportCreator.createWorkflowStats(options);
        }
        if (options.isApprovalsReport()) {
            return this.createApprovalsReport(options, paginationSupport);
        }
        if (options.isDashboardReport()) {
            return this.createDashboardReport(options, paginationSupport);
        }
        if (options.isTasksReport()) {
            return this.createTasksReport(options, paginationSupport);
        }
        List<String> spaceList = options.getSpaceKey() == null ? options.getStateNames() : (!options.getStateNames().isEmpty() && !options.isStatesActionReport() ? this.workflowSearchService.getFilteredSpaceStates(options) : this.workflowSearchService.getSpaceStates(options.getSpaceKey()));
        if (options.isStatesReport()) {
            return this.createStatesReport(options, spaceList, paginationSupport);
        }
        if (!spaceList.isEmpty()) {
            options.setStatesReport(true);
            return this.createStatesReport(options, spaceList, paginationSupport);
        }
        options.setApprovalsReport(true);
        return this.createApprovalsReport(options, paginationSupport);
    }

    private WorkflowReport createStatesReport(WorkflowReportOptions options, List<String> stateNames, PaginationSupport<?> paginationSupport) {
        WorkflowReport report = new WorkflowReport(options, stateNames, paginationSupport);
        paginationSupport.setStartIndex(this.getStartIndexFromRequest());
        String stateName = stateNames.contains(this.getRequestParam("state", options.getStateNameAsString())) ? this.getRequestParam("state", options.getStateNameAsString()) : options.getStateNameAsString();
        String assignee = options.getAssignee();
        List<String> assignees = this.workflowSearchService.getSpaceAssignees(options.getSpaceKey());
        options.setStateNames(stateName);
        options.setAssignee(assignee);
        report.setCurrentStateName(stateName);
        report.setAssignees(assignees);
        report.setHasDueDate(this.workflowSearchService.hasDueDate(options.getSpaceKey()));
        if (StringUtils.isNotBlank((CharSequence)assignee)) {
            report.setCurrentAssignee(assignee);
        }
        List<WorkflowReportEntry> entries = this.getEntries(options, paginationSupport, stateName);
        report.setEntries(entries);
        return report;
    }

    private WorkflowReport createDashboardReport(WorkflowReportOptions options, PaginationSupport<?> paginationSupport) {
        WorkflowReport report = new WorkflowReport(options, paginationSupport);
        paginationSupport.setStartIndex(this.getStartIndexFromRequest());
        report.setEntries(this.getDashboardEntries(options, paginationSupport));
        return report;
    }

    private WorkflowReport createTasksReport(WorkflowReportOptions options, PaginationSupport<?> paginationSupport) {
        WorkflowReport report = new WorkflowReport(options, paginationSupport);
        paginationSupport.setStartIndex(this.getStartIndexFromRequest());
        String assignee = this.getRequestParam("assignee", options.getAssignee());
        List<String> assignees = this.workflowSearchService.getSpaceAssignees(options.getSpaceKey());
        report.setAssignees(assignees);
        report.setCurrentAssignee(assignee);
        report.setEntries(this.getSpaceTasksEntries(options, paginationSupport));
        return report;
    }

    private WorkflowReport createApprovalsReport(WorkflowReportOptions options, PaginationSupport<?> paginationSupport) {
        List<Approval> approvals = this.workflowAccessor.getAllApprovalsForSpace(options.getSpaceKey());
        WorkflowReport report = new WorkflowReport(approvals, paginationSupport, options);
        paginationSupport.setStartIndex(this.getStartIndexFromRequest());
        String approvalName = this.getRequestParam("approval", options.getApprovalName());
        String filter = this.getRequestParam("filter", options.getApprovalFilter());
        if (!StringUtils.isNotBlank((CharSequence)filter)) {
            filter = "pending";
        }
        if (!StringUtils.isNotBlank((CharSequence)approvalName)) {
            if (approvals.isEmpty()) {
                paginationSupport.setItems(Collections.emptyList());
                return report;
            }
            StringBuilder approvalNamesTokenized = new StringBuilder();
            for (Approval approval : approvals) {
                approvalNamesTokenized.append(approval.getName()).append(",");
            }
            approvalNamesTokenized = new StringBuilder(StringUtils.substring((String)approvalNamesTokenized.toString(), (int)0, (int)-1));
            approvalName = approvalNamesTokenized.toString();
        }
        options.setApprovalFilter(filter, approvalName);
        report.setCurrentApprovalName(approvalName);
        report.setCurrentFilter(filter);
        List<WorkflowReportEntry> entries = this.getEntries(options, paginationSupport, report, approvalName, filter);
        report.setEntries(entries);
        return report;
    }

    @Override
    public WorkflowReportOptions makeOptions(MacroInfo macroInfo) {
        WorkflowReportSortEnum sort;
        String space = this.getSpace(macroInfo);
        String sortName = macroInfo.getMacroParams().getString("sort", null);
        NamedSort namedSort = null;
        if (sortName != null) {
            String order;
            if (sortName.startsWith("-")) {
                order = "descending";
                sortName = sortName.substring(1);
            } else if (sortName.startsWith("+")) {
                order = "ascending";
                sortName = sortName.substring(1);
            } else {
                order = "ascending";
            }
            sort = WorkflowReportSortEnum.makeSortNoDefault(sortName, order);
            if (sort == null) {
                namedSort = new NamedSort(sortName, WorkflowReportSortEnum.getOrder(order));
            }
        } else {
            sort = WorkflowReportSortEnum.getDefault();
        }
        int maxEntries = macroInfo.getMacroParams().getInteger("max", 20);
        WorkflowReportOptions options = new WorkflowReportOptions(space, macroInfo.getSpace().getKey(), sort, maxEntries);
        options.setCustomSort((SearchSort)namedSort);
        options.setStatesReport(true);
        this.addFilters(options, macroInfo);
        String labels = macroInfo.getMacroParams().getString("labels", null);
        if (labels == null) {
            labels = macroInfo.getMacroParams().getString("label", null);
        }
        this.setOptionLabels(options, labels);
        String state = macroInfo.getMacroParams().getString("state", macroInfo.getMacroParams().getString("states", null));
        if (state != null) {
            options.setStateNames(state.toLowerCase());
        }
        return options;
    }

    @Override
    public WorkflowReportOptions makeOptions(Map<String, String> macroParams) {
        WorkflowReportSortEnum sort;
        String space = this.getSpace(macroParams);
        String sortName = MapUtils.getString(macroParams, "sort");
        NamedSort namedSort = null;
        if (sortName != null) {
            String order;
            if (sortName.startsWith("-")) {
                order = "descending";
                sortName = sortName.substring(1);
            } else if (sortName.startsWith("+")) {
                order = "ascending";
                sortName = sortName.substring(1);
            } else {
                order = "ascending";
            }
            sort = WorkflowReportSortEnum.makeSortNoDefault(sortName, order);
            if (sort == null) {
                namedSort = new NamedSort(sortName, WorkflowReportSortEnum.getOrder(order));
            }
        } else {
            sort = WorkflowReportSortEnum.getDefault();
        }
        int maxEntries = MapUtils.getIntValue(macroParams, "max", 20);
        WorkflowReportOptions options = new WorkflowReportOptions(space, space, sort, maxEntries);
        options.setCustomSort((SearchSort)namedSort);
        options.setStatesReport(true);
        this.addFilters(options, macroParams);
        String labels = MapUtils.getString(macroParams, "labels");
        if (labels == null) {
            labels = MapUtils.getString(macroParams, "label");
        }
        this.setOptionLabels(options, labels);
        String state = MapUtils.getString(macroParams, "state", MapUtils.getString(macroParams, "states"));
        if (state != null) {
            options.setStateNames(state.toLowerCase());
        }
        return options;
    }

    private void setOptionLabels(WorkflowReportOptions options, String labels) {
        if (Objects.isNull(labels)) {
            return;
        }
        boolean all = false;
        if (labels.startsWith("&")) {
            all = true;
            labels = labels.substring(1);
        }
        for (String labelName : MiscUtils.splitAndTrim(labels)) {
            options.addLabel(new Label(labelName));
        }
        options.setMustHaveAllLabels(all);
    }

    private String getSpace(Map<String, String> params) {
        return MapUtils.getString(params, "space", MapUtils.getString(params, "spaces", MapUtils.getString(params, "currentspace")));
    }

    private String getSpace(MacroInfo macroInfo) {
        String space = macroInfo.getMacroParams().getString("space", macroInfo.getMacroParams().getString("spaces", null));
        if (space == null) {
            return macroInfo.getSpace().getKey();
        }
        return space;
    }

    private void addFilters(WorkflowReportOptions options, Map<String, String> params) {
        String filters = MapUtils.getString(params, "filter", MapUtils.getString(params, "filters"));
        options.setFilters(filters);
    }

    private void addFilters(WorkflowReportOptions options, MacroInfo macroInfo) {
        String filters = macroInfo.getMacroParams().getString("filter", macroInfo.getMacroParams().getString("filters", null));
        options.setFilters(filters);
    }

    private List<WorkflowReportEntry> getDashboardEntries(WorkflowReportOptions options, PaginationSupport<?> paginationSupport) {
        List<WorkflowReportEntry> dashboardEntries = this.workflowReportCreator.createDashboardReport(options, paginationSupport, page -> {
            ArrayList<WorkflowReportEntry> entries;
            block23: {
                entries = new ArrayList<WorkflowReportEntry>();
                PageState pageState = (PageState)this.stateService.getCurrentState((ContentEntityObject)page);
                if (pageState == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("pagestate is null");
                    }
                    return null;
                }
                Assignment assignment = pageState.getLastAssignment();
                if (assignment != null) {
                    if (options.getUserName().equals(((com.comalatech.confluence.states.model.Assignment)assignment).getAssignee())) {
                        entries.add(new WorkflowReportEntry(page, pageState, null));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("assignment is null");
                }
                if (log.isDebugEnabled()) {
                    log.debug("assignments entries:{}", (Object)entries.size());
                }
                if (this.workflowsFeatureManager.isWorkflowsApp()) {
                    this.loadPageTasks(options, page, pageState, entries);
                } else if (log.isDebugEnabled()) {
                    log.debug("pagetasks entries won't be shown");
                }
                try {
                    PageWorkflows pageWorkflows = this.workflowAccessor.getWorkflows(page);
                    if (Objects.isNull(pageWorkflows)) {
                        if (log.isDebugEnabled()) {
                            log.debug("pageworkflows is null");
                        }
                        return entries;
                    }
                    List<Approval> uncompletedApprovals = this.approvalManager.getUncompletedApprovals(page, pageState);
                    if (uncompletedApprovals.isEmpty()) {
                        if (log.isDebugEnabled()) {
                            log.debug("pageworkflows uncompletedapprovals is empty");
                        }
                        return entries;
                    }
                    block2: for (Approval approval : uncompletedApprovals) {
                        ApprovalCheck approvalCheck = this.approvalAccessor.getLatestApprovalCheck(page, pageState, approval.getName(), 0);
                        if (Objects.isNull(approvalCheck)) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("pageworkflows uncompletedapprovals approvalcheck is null");
                            continue;
                        }
                        String[] requiredApprovers = approvalCheck.getRequiredApprovers();
                        if (requiredApprovers != null && requiredApprovers.length > 0) {
                            for (String approver : requiredApprovers) {
                                if (options.getUserName().equals(approver)) {
                                    List<Approver> approvers = approvalCheck.getLatestApprovers(true);
                                    approvers.addAll(approvalCheck.getLatestApprovers(false));
                                    if (!this.approverListContainsUser(approvers, approver) || !approvalCheck.isCheckUpToDate(page, pageState, true, this.attachmentManager)) {
                                        DecoratedApprovalCheck decoratedApprovalCheck = new DecoratedApprovalCheck(pageWorkflows.getValueStore(), approvalCheck, approval, false, false, this.attachmentManager);
                                        if (decoratedApprovalCheck.canExecute()) {
                                            entries.add(new WorkflowReportEntry(page, decoratedApprovalCheck, pageState));
                                            continue block2;
                                        }
                                        if (!log.isDebugEnabled()) continue;
                                        log.debug("pageworkflows uncompletedapprovals approvalcheck requiredApprovers decoratedApprovalCheck can not execute");
                                        continue;
                                    }
                                    if (!log.isDebugEnabled()) continue;
                                    log.debug("pageworkflows uncompletedapprovals approvalcheck requiredApprovers latestApprover list don't contain approver or not up to date");
                                    continue;
                                }
                                if (!log.isDebugEnabled()) continue;
                                log.debug("pageworkflows uncompletedapprovals approvalcheck requiredApprovers approver does not match");
                            }
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug("pageworkflows uncompletedapprovals approvalcheck requiredApprovers is empty");
                    }
                }
                catch (WorkflowException ignored) {
                    if (!log.isDebugEnabled()) break block23;
                    log.debug("getDashboardEntries() -> exception:" + ignored.getMessage());
                }
            }
            return entries;
        });
        dashboardEntries.sort(WorkflowReportEntry.DASHBOARD_COMPARATOR);
        return dashboardEntries;
    }

    private void loadPageTasks(WorkflowReportOptions options, AbstractPage page, PageState pageState, List<WorkflowReportEntry> entries) {
        List<PageTask> pageTasks = pageState.getPageTasks().get();
        if (pageTasks.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("pageTasks is empty");
            }
            return;
        }
        for (PageTask task : pageTasks) {
            if (task.isCompleted()) continue;
            Assignment assignment = task.getLastAssignment();
            if (assignment != null) {
                if (!options.getUserName().equals(((com.comalatech.confluence.states.model.Assignment)assignment).getAssignee())) continue;
                entries.add(new WorkflowReportEntry(page, pageState, task, null, null));
                break;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("pageTasks: task assignment is null");
        }
    }

    private boolean approverListContainsUser(List<Approver> approvers, String matchUserName) {
        for (Approver approver : approvers) {
            if (approver == null || !approver.getUserName().equals(matchUserName)) continue;
            return true;
        }
        return false;
    }

    private List<WorkflowReportEntry> getSpaceTasksEntries(WorkflowReportOptions options, PaginationSupport<?> paginationSupport) {
        return this.workflowReportCreator.createTasksReport(options, paginationSupport, page -> {
            ArrayList<WorkflowReportEntry> entries = new ArrayList<WorkflowReportEntry>();
            if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)page)) {
                return null;
            }
            PageState pageState = (PageState)this.stateService.getCurrentState((ContentEntityObject)page);
            if (pageState == null) {
                return null;
            }
            PageWorkflows pageWorkflows = null;
            TasksReportFilter tasksFilter = options.getTasksFilter();
            for (PageTask task : pageState.getPageTasks().get()) {
                if (tasksFilter != TasksReportFilter.ALL_TASKS && (tasksFilter != TasksReportFilter.ACTIVE_TASKS || task.isCompleted()) && (tasksFilter != TasksReportFilter.COMPLETED_TASKS || !task.isCompleted())) continue;
                if (options.getAssignee() != null) {
                    Assignment assignment;
                    TaskCompletion completion;
                    if (tasksFilter == TasksReportFilter.ALL_TASKS) {
                        Assignment assignment2;
                        completion = task.getLastCompletion();
                        if (completion != null && !completion.getPerformer().equals(options.getAssignee()) || (assignment2 = task.getLastAssignment()) == null || !((com.comalatech.confluence.states.model.Assignment)assignment2).isUserAssigned(options.getAssignee())) {
                            continue;
                        }
                    } else if (tasksFilter != TasksReportFilter.ACTIVE_TASKS ? tasksFilter == TasksReportFilter.COMPLETED_TASKS && (completion = task.getLastCompletion()) != null && !completion.getPerformer().equals(options.getAssignee()) : (assignment = task.getLastAssignment()) == null || !((com.comalatech.confluence.states.model.Assignment)assignment).isUserAssigned(options.getAssignee())) continue;
                }
                if (pageWorkflows == null) {
                    pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
                }
                WorkflowReportEntry entry = new WorkflowReportEntry(page, pageState, task, null, pageWorkflows != null ? pageWorkflows.getStatesContainer() : null);
                entries.add(entry);
            }
            return entries;
        });
    }

    private List<WorkflowReportEntry> getEntries(WorkflowReportOptions options, PaginationSupport<?> paginationSupport, String filteredStateName) {
        boolean checkAvailable = options.getUserName() != null;
        ConfluenceUser user = null;
        if (checkAvailable && (user = this.userAccessor.getUserByName(options.getUserName())) == null) {
            return Collections.emptyList();
        }
        ConfluenceUser daUser = user;
        ConfluenceUser loggedUser = AuthenticatedUserThreadLocal.get();
        List<WorkflowReportEntry> entries = null;
        for (int i = 0; i < 10; ++i) {
            entries = this.workflowReportCreator.createStatesReport(options, paginationSupport, (AbstractPage page) -> {
                PageState pageState = (PageState)this.stateService.getCurrentState((ContentEntityObject)page);
                if (pageState == null) {
                    pageState = new PageState(filteredStateName, page.getCreationDate(), 1, page.getCreatorName(), true);
                }
                State state = null;
                PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
                if (pageWorkflows != null) {
                    com.comalatech.workflow.model.State publishedState;
                    StatesContainer statesContainer = pageWorkflows.getStatesContainer();
                    if (statesContainer != null) {
                        state = statesContainer.getState(pageState);
                    }
                    if (!((publishedState = this.stateService.getPublishedState((ContentEntityObject)page)) != null && publishedState.getContentVersion() >= page.getVersion() || this.workflowPermissionManager.canViewDrafts(page, loggedUser))) {
                        return null;
                    }
                    if (checkAvailable) {
                        if (state == null || state.getApprovals().isEmpty()) {
                            return null;
                        }
                        boolean approvalAvailable = false;
                        for (Approval approval : state.getApprovals()) {
                            if (!this.approvalManager.canApprove(page, daUser, approval.getName())) continue;
                            approvalAvailable = true;
                            break;
                        }
                        if (!approvalAvailable) {
                            return null;
                        }
                    }
                    return Collections.singletonList(new WorkflowReportEntry(page, pageState, statesContainer));
                }
                return Collections.emptyList();
            });
            if (!checkAvailable || !entries.isEmpty() || paginationSupport.getNextStartIndex() < 0) break;
            paginationSupport.setStartIndex(paginationSupport.getNextStartIndex());
        }
        return entries;
    }

    private List<WorkflowReportEntry> getEntries(WorkflowReportOptions options, PaginationSupport<?> paginationSupport, WorkflowReport report, String approvalName, String filter) {
        boolean checkAvailable = options.getUserName() != null;
        ConfluenceUser user = null;
        if (checkAvailable && (user = this.userAccessor.getUserByName(options.getUserName())) == null) {
            return Collections.emptyList();
        }
        List<WorkflowReportEntry> entries = null;
        boolean pending = filter.equalsIgnoreCase("pending");
        ConfluenceUser daUser = user;
        ConfluenceUser loggedUser = AuthenticatedUserThreadLocal.get();
        for (int i = 0; i < 10; ++i) {
            entries = this.workflowReportCreator.createApprovalsReport(options, paginationSupport, page -> {
                if (checkAvailable && !this.approvalManager.canApprove(page, daUser, approvalName)) {
                    return null;
                }
                ApprovalCheck approvalCheck = this.approvalAccessor.getLatestApprovalCheck(page, null, approvalName, 0);
                DecoratedApprovalCheck decoratedCheck = null;
                PageState pageState = null;
                com.comalatech.workflow.model.State publishedState = this.stateService.getPublishedState((ContentEntityObject)page);
                if (!(publishedState != null && publishedState.getContentVersion() >= page.getVersion() || this.workflowPermissionManager.canViewDrafts(page, loggedUser))) {
                    return null;
                }
                if (approvalCheck == null) {
                    if (pending) {
                        pageState = (PageState)this.stateService.getCurrentState((ContentEntityObject)page);
                        PageWorkflows pageWorkflows = null;
                        try {
                            pageWorkflows = this.workflowAccessor.getWorkflows(page);
                        }
                        catch (WorkflowException e) {
                            log.warn(e.getMessage());
                        }
                        if (pageWorkflows != null) {
                            ValueStore valueStore = this.valueStoreManager.createValueStore(page);
                            Approval approval = pageWorkflows.getApproval(approvalName);
                            if (approval != null) {
                                try {
                                    decoratedCheck = new DecoratedApprovalCheck(valueStore, approval, this.attachmentManager);
                                }
                                catch (WorkflowException e) {
                                    log.error("", (Throwable)e);
                                }
                            }
                        }
                    } else {
                        log.warn("could not get approval check, re-indexing is required");
                    }
                } else {
                    ValueStore valueStore = this.valueStoreManager.createValueStore(page);
                    pageState = (PageState)this.stateService.getCurrentState((ContentEntityObject)page);
                    decoratedCheck = new DecoratedApprovalCheck(valueStore, approvalCheck, this.attachmentManager);
                }
                if (pageState != null) {
                    report.setHasStates(true);
                }
                return Collections.singletonList(new WorkflowReportEntry(page, decoratedCheck, pageState));
            });
            if (!checkAvailable || !entries.isEmpty() || paginationSupport.getNextStartIndex() < 0) break;
            paginationSupport.setStartIndex(paginationSupport.getNextStartIndex());
        }
        if (checkAvailable) {
            report.setShowPartialPagination(paginationSupport.getStartIndex() > 0 || paginationSupport.getNextStartIndex() > 0);
            if (paginationSupport.getNextStartIndex() > 0) {
                report.setNextIndex(paginationSupport.getNextStartIndex());
            }
            paginationSupport.setStartIndex(0);
            paginationSupport.setTotal(entries.size());
        }
        return entries;
    }

    private int getStartIndexFromRequest() {
        String startIndex = this.getRequestParam("startIndex");
        if (startIndex == null) {
            return 0;
        }
        try {
            return Integer.parseInt(startIndex);
        }
        catch (NumberFormatException e) {
            log.error("invalid start index");
            return 0;
        }
    }

    private String getRequestParam(String key, String defaultValue) {
        String value = this.getRequestParam(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private String getRequestParam(String key) {
        String[] result;
        Object param;
        if (ServletActionContext.getRequest() != null && ServletActionContext.getRequest().getParameterMap() != null && (param = ServletActionContext.getRequest().getParameterMap().get(key)) != null && (result = (String[])param).length != 0) {
            return result[0];
        }
        return null;
    }
}

