/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.workflowNamesRepository;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import com.comalatech.confluence.workflow.workflowNamesRepository.WorkflowNamesRepository;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class WorkflowNamesRepositoryImpl
implements WorkflowNamesRepository {
    private static final String WORKFLOW_NAMES_KEY = "com.comalatech.workflow.workflownames";
    private final BandanaManager bandanaManager;

    public WorkflowNamesRepositoryImpl(@ComponentImport BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @Override
    public void addWorkflowName(String name) {
        List<String> names = this.getWorkflowNames();
        if (!names.contains(name) && !name.isEmpty()) {
            this.bandanaManager.setValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, WORKFLOW_NAMES_KEY, (Object)this.appendWorkflowname(name, names));
        }
    }

    @Override
    public List<String> getWorkflowNames() {
        Object stateNames = this.bandanaManager.getValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, WORKFLOW_NAMES_KEY);
        if (stateNames == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(stateNames.toString().split(",")).map(String::trim).collect(Collectors.toList());
    }

    @Override
    public void removeAllNames() {
        this.bandanaManager.removeValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, WORKFLOW_NAMES_KEY);
    }

    private String appendWorkflowname(String workflowName, List<String> bandanaNames) {
        HashSet<String> names = new HashSet<String>();
        names.add(workflowName);
        if (!bandanaNames.isEmpty()) {
            Set bandanaNamesSet = bandanaNames.stream().map(String::trim).collect(Collectors.toSet());
            names.addAll(bandanaNamesSet);
        }
        return String.join((CharSequence)", ", names);
    }
}

