/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.usage.accessor;

import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.comalatech.confluence.plugin.PluginSettingsService;
import com.comalatech.confluence.workflow.usage.accessor.WorkflowsUsageReportAccessor;
import com.comalatech.confluence.workflow.usage.accessor.model.MetadataWorkflowReportTaskRecord;
import com.comalatech.confluence.workflow.usage.accessor.model.PageWorkflowReportTaskRecord;
import com.comalatech.confluence.workflow.usage.accessor.model.RestrictionsWorkflowReportTaskRecord;
import com.comalatech.confluence.workflow.usage.accessor.model.SpaceWorkflowReportTaskRecord;
import com.comalatech.confluence.workflow.usage.model.MetadataWorkflowReportEntry;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultWorkflowsUsageReportAccessor
implements WorkflowsUsageReportAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowsUsageReportAccessor.class);
    private static final String PAGE_WORKFLOWS_USAGE_KEY = "pageworkflowsusage";
    private static final String SPACE_WORKFLOWS_USAGE_KEY = "spaceworkflowsusage";
    private static final String RESTRICTIONS_WORKFLOWS_USAGE_KEY = "restrictionworkflowsusage";
    private static final String METADATA_WORKFLOW_USAGE_KEY = "metadataworkflowsusage";
    private final PluginSettingsService pluginSettingsService;
    private final EntityManagerProvider entityManagerProvider;
    private final ObjectMapper objectMapper;

    public DefaultWorkflowsUsageReportAccessor(PluginSettingsService pluginSettingsService, EntityManagerProvider entityManagerProvider) {
        this.pluginSettingsService = pluginSettingsService;
        this.entityManagerProvider = entityManagerProvider;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public PageWorkflowReportTaskRecord getPageWorkflowsReportTaskRecord() {
        String pageWorkflowsUsageSetting = this.pluginSettingsService.getSetting(PAGE_WORKFLOWS_USAGE_KEY);
        if (pageWorkflowsUsageSetting != null) {
            try {
                return this.objectMapper.readValue(pageWorkflowsUsageSetting, PageWorkflowReportTaskRecord.class);
            }
            catch (JsonProcessingException e) {
                log.error("Failed retrieving the PageWorkflowReportTaskRecord from the pluggingSettingsService", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void savePageWorkflowsReportTaskRecord(PageWorkflowReportTaskRecord pageWorkflowReportTaskRecord) {
        try {
            this.pluginSettingsService.addSetting(PAGE_WORKFLOWS_USAGE_KEY, this.objectMapper.writeValueAsString(pageWorkflowReportTaskRecord));
        }
        catch (JsonProcessingException e) {
            log.error("Failed saving the PageWorkflowReportTaskRecord on the pluggingSettingsService", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public SpaceWorkflowReportTaskRecord getSpaceWorkflowsReportTaskRecord() {
        String spaceWorkflowsUsageSetting = this.pluginSettingsService.getSetting(SPACE_WORKFLOWS_USAGE_KEY);
        if (spaceWorkflowsUsageSetting != null) {
            try {
                return this.objectMapper.readValue(spaceWorkflowsUsageSetting, SpaceWorkflowReportTaskRecord.class);
            }
            catch (JsonProcessingException e) {
                log.error("Failed retrieving the SpaceWorkflowReportTaskRecord from the pluggingSettingsService", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void saveSpaceWorkflowsReportTaskRecord(SpaceWorkflowReportTaskRecord spaceWorkflowReportTaskRecord) {
        try {
            this.pluginSettingsService.addSetting(SPACE_WORKFLOWS_USAGE_KEY, this.objectMapper.writeValueAsString(spaceWorkflowReportTaskRecord));
        }
        catch (JsonProcessingException e) {
            log.error("Failed saving the SpaceWorkflowReportTaskRecord on the pluggingSettingsService", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public RestrictionsWorkflowReportTaskRecord getRestrictionsWorkflowsReportTaskRecord() {
        String restrictionsWorkflowsUsageSetting = this.pluginSettingsService.getSetting(RESTRICTIONS_WORKFLOWS_USAGE_KEY);
        if (Objects.isNull(restrictionsWorkflowsUsageSetting)) {
            return null;
        }
        try {
            return this.objectMapper.readValue(restrictionsWorkflowsUsageSetting, RestrictionsWorkflowReportTaskRecord.class);
        }
        catch (JsonProcessingException e) {
            log.error("Failed retrieving the RestrictionsWorkflowReportTaskRecord from the pluggingSettingsService", (Throwable)e);
            return null;
        }
    }

    @Override
    public void saveRestrictionsWorkflowsReportTaskRecord(RestrictionsWorkflowReportTaskRecord restrictionsWorkflowReportTaskRecord) {
        try {
            this.pluginSettingsService.addSetting(RESTRICTIONS_WORKFLOWS_USAGE_KEY, this.objectMapper.writeValueAsString(restrictionsWorkflowReportTaskRecord));
        }
        catch (JsonProcessingException e) {
            log.error("Failed saving the RestrictionsWorkflowReportTaskRecord on the pluggingSettingsService", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public MetadataWorkflowReportTaskRecord getMetadataWorkflowReportTaskRecord() {
        String metadataWorkflowsUsageSetting = this.pluginSettingsService.getSetting(METADATA_WORKFLOW_USAGE_KEY);
        if (Objects.isNull(metadataWorkflowsUsageSetting)) {
            return null;
        }
        try {
            return this.objectMapper.readValue(metadataWorkflowsUsageSetting, MetadataWorkflowReportTaskRecord.class);
        }
        catch (JsonProcessingException e) {
            log.error("Failed retrieving the MetadataWorkflowReportTaskRecord from the pluggingSettingsService", (Throwable)e);
            return null;
        }
    }

    @Override
    public void saveMetadataReportTaskRecord(MetadataWorkflowReportTaskRecord metadataWorkflowReportTaskRecord) {
        try {
            this.pluginSettingsService.addSetting(METADATA_WORKFLOW_USAGE_KEY, this.objectMapper.writeValueAsString(metadataWorkflowReportTaskRecord));
        }
        catch (JsonProcessingException e) {
            log.error("Failed saving the MetadataReportTaskRecord on the pluggingSettingsService", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<MetadataWorkflowReportEntry> getMetadataWorkflowsReport() {
        String METADATA_QUERY = "select space.key as key, space.name as name, content.id as contentId, content.title as contentTitle, contentProperty.key as metadataKey, contentProperty.stringVal as stringVal, contentProperty.textVal as textVal from BucketPropertySetItem contentProperty, Space space, ContentEntityObject content where content.space.id = space.id and contentProperty.entityId = content.id and contentProperty.key like 'metadata.%' and contentProperty.key not like 'metadata.awpState' and content.contentStatus = 'current'";
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("select space.key as key, space.name as name, content.id as contentId, content.title as contentTitle, contentProperty.key as metadataKey, contentProperty.stringVal as stringVal, contentProperty.textVal as textVal from BucketPropertySetItem contentProperty, Space space, ContentEntityObject content where content.space.id = space.id and contentProperty.entityId = content.id and contentProperty.key like 'metadata.%' and contentProperty.key not like 'metadata.awpState' and content.contentStatus = 'current'", Tuple.class);
        return query.getResultList().stream().map(queryRecord -> {
            String stringVal = (String)queryRecord.get("stringVal");
            return MetadataWorkflowReportEntry.builder().spaceKey((String)queryRecord.get("key")).spaceName((String)queryRecord.get("name")).contentId((Long)queryRecord.get("contentId")).contentTitle((String)queryRecord.get("contentTitle")).metadataName((String)queryRecord.get("metadataKey")).metadataValue(Objects.nonNull(stringVal) ? stringVal : (String)queryRecord.get("textVal")).build();
        }).collect(Collectors.toList());
    }
}

