/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.tasks.handler;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.ValueStoreManager;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowActionManager;
import com.comalatech.confluence.workflow.tasks.handler.AbstractQueuedJobHandler;
import com.comalatech.confluence.workflow.tasks.model.WorkflowActionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class WorkflowActionHandlerImpl
extends AbstractQueuedJobHandler<WorkflowActionModel> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowActionHandlerImpl.class);
    private final ContentEntityManager contentEntityManager;
    private final WorkflowActionManager workflowActionManager;
    private final ValueStoreManager valueStoreManager;
    private final WorkflowAccessor workflowAccessor;

    public WorkflowActionHandlerImpl(@ComponentImport UserAccessor userAccessor, WorkflowActionManager workflowActionManager, ValueStoreManager valueStoreManager, WorkflowAccessor workflowAccessor, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
        this.userAccessor = userAccessor;
        this.workflowActionManager = workflowActionManager;
        this.valueStoreManager = valueStoreManager;
        this.workflowAccessor = workflowAccessor;
    }

    @Override
    public void handle(WorkflowActionModel model) {
        AbstractPage abstractPage;
        if (log.isDebugEnabled()) {
            log.debug("Processing action: " + model.getAction() + " on pageId: " + model.getPageId());
        }
        if ((abstractPage = (AbstractPage)this.contentEntityManager.getById(model.getPageId().longValue())) == null) {
            log.error("Cannot execute action " + model.getAction() + " on content with id " + model.getPageId() + " because the page/blog-post does not exist");
        } else {
            try {
                PageContext renderContext = abstractPage.toPageContext();
                renderContext.getParams().putAll(model.getWorkflowProperties());
                ValueStore valueStore = this.valueStoreManager.createValueStore(abstractPage, model.getValueStoreProperties(), true);
                valueStore.setPageWorkflows(this.workflowAccessor.getPageWorkflows(abstractPage));
                this.workflowActionManager.executeAction(valueStore, model.getAction(), model.getNewEventName(), (RenderContext)renderContext);
            }
            catch (Exception e) {
                throw new RuntimeException("There was an error processing action: " + model.getAction() + " on pageId: " + model.getPageId(), e);
            }
        }
    }
}

