/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.tasks;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.comalatech.confluence.states.StateManager;
import com.comalatech.confluence.states.event.StateExpireEvent;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.PageStateTimer;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.tasks.PageTaskManager;
import com.comalatech.confluence.tasks.event.DefaultTaskDueDateExpiredEvent;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.service.WorkflowSearchService;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowExpirationJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(WorkflowExpirationJob.class);
    private final WorkflowSearchService workflowSearchService;
    private final ConfluenceIndexer indexer;
    private final WorkflowAccessor workflowAccessor;
    private final StateManager stateManager;
    private final EventPublisher eventPublisher;
    private final PageTaskManager pageTaskManager;
    private final TransactionTemplate txTemplate;
    private final PageManager pageManager;
    private final WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager;
    private final TransactionalExecutorFactory transactionalExecutorFactory;
    private final DarkFeatureManager darkFeatureManager;

    public WorkflowExpirationJob(WorkflowSearchService workflowSearchService, @ComponentImport ConfluenceIndexer indexer, WorkflowAccessor workflowAccessor, StateManager stateManager, @ComponentImport EventPublisher eventPublisher, @ComponentImport TransactionalExecutorFactory transactionalExecutorFactory, PageTaskManager pageTaskManager, @ComponentImport TransactionTemplate txTemplate, @ComponentImport PageManager pageManager, WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager, @ComponentImport DarkFeatureManager darkFeatureManager) {
        this.workflowSearchService = workflowSearchService;
        this.indexer = indexer;
        this.workflowAccessor = workflowAccessor;
        this.stateManager = stateManager;
        this.eventPublisher = eventPublisher;
        this.transactionalExecutorFactory = transactionalExecutorFactory;
        this.pageTaskManager = pageTaskManager;
        this.txTemplate = txTemplate;
        this.pageManager = pageManager;
        this.workflowAdvancedConfigurationManager = workflowAdvancedConfigurationManager;
        this.darkFeatureManager = darkFeatureManager;
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        log.debug("Workflow expiration job starting ...");
        int batchSize = this.workflowAdvancedConfigurationManager.getExpirationJobBatchSize();
        try {
            PluginContainerManager.autowireComponent(this);
            Date now = new Date();
            List<AbstractPage> expiredPages = this.workflowSearchService.getExpiredPages(now, batchSize);
            log.debug("Batch size {}. Number of expired pages {} found", (Object)batchSize, (Object)expiredPages.size());
            if (expiredPages.isEmpty()) {
                log.debug("Nothing to process, Workflow expiration job finished!");
                return JobRunnerResponse.success((String)"Job finished successfully.");
            }
            ArrayList<AbstractPage> pagesToReindex = new ArrayList<AbstractPage>();
            if (this.darkFeatureManager.isFeatureEnabledForAllUsers("comalatech.workflows.expiration.job.transaction.page.enabled")) {
                log.debug("Dark feature enabled, single transaction per page processed is going to be performed.");
                for (AbstractPage expiredPage : expiredPages) {
                    try {
                        this.txTemplate.execute(() -> {
                            if (request.isCancellationRequested()) {
                                return JobRunnerResponse.aborted((String)"Job cancelled.");
                            }
                            AbstractPage content = (AbstractPage)this.pageManager.getById(expiredPage.getId());
                            if (content == null) {
                                log.warn("Page with id {} does not exist.", (Object)expiredPage.getIdAsString());
                                return null;
                            }
                            this.processExpiredPage(content, now, pagesToReindex);
                            return null;
                        });
                    }
                    catch (Exception ex) {
                        log.error("Error processing the page: " + expiredPage.getId(), (Throwable)ex);
                    }
                }
                log.debug("Reindexing {} pages", (Object)pagesToReindex.size());
                this.reindexPages(pagesToReindex);
                log.debug("Workflow expiration job finished!");
                return JobRunnerResponse.success((String)"Job finished successfully.");
            }
            return (JobRunnerResponse)this.txTemplate.execute(() -> {
                log.debug("Single transaction per batch processed is going to be performed.");
                for (AbstractPage expiredPage : expiredPages) {
                    if (request.isCancellationRequested()) {
                        return JobRunnerResponse.aborted((String)"Job cancelled.");
                    }
                    AbstractPage content = (AbstractPage)this.pageManager.getById(expiredPage.getId());
                    if (content == null) {
                        log.warn("Page with id {} does not exist.", (Object)expiredPage.getIdAsString());
                        continue;
                    }
                    this.processExpiredPage(content, now, pagesToReindex);
                }
                log.debug("Reindexing {} pages", (Object)pagesToReindex.size());
                this.reindexPages(pagesToReindex);
                log.debug("Workflow expiration job finished!");
                return JobRunnerResponse.success((String)"Job finished successfully.");
            });
        }
        catch (Error | Exception e) {
            log.error("Error in workflow expiration job", e);
            return JobRunnerResponse.failed((String)"Job failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpiredPage(AbstractPage expiredPage, Date date, List<AbstractPage> pagesToReindex) {
        boolean needsReindex;
        PageWorkflows workflows;
        log.debug("Processing expired page with id {} and title {}", (Object)expiredPage.getIdAsString(), (Object)expiredPage.getTitle());
        try {
            workflows = this.workflowAccessor.getWorkflows(expiredPage);
            if (workflows == null || workflows.getStatesContainer() == null) {
                return;
            }
        }
        catch (WorkflowException e) {
            log.warn(e.getMessage());
            return;
        }
        PageState currentState = workflows.getValueStore().getPageState();
        if (currentState == null) {
            return;
        }
        WorkflowAuthenticatedUserThreadLocal.setInExpiryJob(true);
        try {
            needsReindex = this.processStateTimers(currentState, workflows, date);
            needsReindex = this.processDueTasks(currentState) || needsReindex;
        }
        finally {
            WorkflowAuthenticatedUserThreadLocal.setInExpiryJob(false);
        }
        if (needsReindex) {
            pagesToReindex.add(expiredPage);
        }
    }

    private boolean processStateTimers(PageState currentState, PageWorkflows pageWorkflows, Date date) {
        boolean needsReindex = false;
        if (currentState != null) {
            PageStateTimer pageStateTimer = currentState.getActiveTimer();
            if (pageStateTimer != null && pageStateTimer.getFired() != null) {
                log.debug("The page {} has not been indexed properly as the page expired in {}", (Object)currentState.getPage(), (Object)date);
                return true;
            }
            if (pageStateTimer != null && pageStateTimer.isActive() && pageStateTimer.getDueDate().getTime() < date.getTime()) {
                this.fireTimer(currentState, pageWorkflows, pageStateTimer, date);
                needsReindex = true;
            }
        }
        return needsReindex;
    }

    private boolean processDueTasks(PageState pageState) {
        boolean needsReindex = false;
        List<PageTask> tasks = pageState.getTasks();
        for (PageTask pageTask : tasks) {
            DueDateRecord dueDate = pageTask.getCurrentDueDate();
            if (dueDate != null && dueDate.isExpiryTriggered()) {
                log.debug("The task {} has not been indexed properly as the task already expired", (Object)pageTask.getName());
                needsReindex = true;
            }
            if (dueDate == null || !dueDate.isExpired() || dueDate.isExpiryTriggered()) continue;
            this.eventPublisher.publish((Object)new DefaultTaskDueDateExpiredEvent(this, pageTask, pageState.getPage(), pageState));
            dueDate.setExpiryTriggered(true);
            pageTask.setCurrentDueDate(dueDate);
            this.pageTaskManager.updateTask(pageState.getPage(), pageState, pageTask, null, pageTask.getPerformer());
            needsReindex = true;
        }
        return needsReindex;
    }

    private void reindexPages(List<AbstractPage> pages) {
        this.transactionalExecutorFactory.create().execute(connection -> {
            try {
                for (AbstractPage page : pages) {
                    log.debug("Reindexing page with id {} and title {}", (Object)page.getIdAsString(), (Object)page.getTitle());
                    this.indexer.reIndex((Searchable)page);
                }
            }
            catch (Exception e) {
                log.error("Exception during page reindexing process", (Throwable)e);
            }
            return null;
        });
    }

    private void fireTimer(PageState pageState, PageWorkflows pageWorkflows, PageStateTimer timer, Date fireTime) {
        pageState.fireTimer(fireTime, null);
        AbstractPage page = pageWorkflows.getPage();
        this.stateManager.updateTimer(page, timer);
        State state = pageWorkflows.getStatesContainer().getState(pageState);
        if (state == null) {
            if (log.isDebugEnabled()) {
                log.info("fired timer " + timer.getName() + " on " + page + " with no current state");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.info("firing timer " + timer.getName() + " on " + page);
        }
        try {
            this.eventPublisher.publish((Object)new StateExpireEvent(this, page, pageState, timer));
        }
        catch (Error | Exception e) {
            log.error("error publishing expired event on " + page, e);
        }
    }
}

