/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.stateRepository.job;

import com.atlassian.core.task.TaskQueue;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.comalatech.confluence.dataextractor.queue.AppfireQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StateRepositoryQueueJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(StateRepositoryQueueJob.class);
    private final AppfireQueueService appfireQueueService;
    public static final String STATE_REPOSITORY_QUEUE = "state-repository-queue";

    public StateRepositoryQueueJob(AppfireQueueService appfireQueueService) {
        this.appfireQueueService = appfireQueueService;
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("StateRepositoryQueueJob starting");
        }
        try {
            TaskQueue queue = this.appfireQueueService.getTaskQueue(STATE_REPOSITORY_QUEUE);
            if (queue == null) {
                queue = this.appfireQueueService.addTaskQueue(STATE_REPOSITORY_QUEUE);
            }
            if (queue.isFlushing()) {
                log.debug("Task queue {} was already being flushed - skipped this time", (Object)queue);
                return JobRunnerResponse.aborted((String)("Task queue " + queue + " was already being flushed"));
            }
            log.debug("Executing tasks for queue {}, queue size {}", (Object)queue, (Object)queue.size());
            queue.flush();
            log.debug("StateRepositoryQueueJob finished! ");
            return JobRunnerResponse.success((String)("Executed tasks for queue " + queue));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JobRunnerResponse.failed((String)"Job failed.");
        }
    }
}

