/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.model;

import com.comalatech.confluence.adhocworkflows.rest.model.User;
import com.comalatech.workflow.model.InputField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@ApiModel(description="Information related to the different actions that can be taken in current state. See ParametersAction, ChangeAction or ApprovalAction subtypes", subTypes={ParametersAction.class, ChangeAction.class, ApprovalAction.class})
public abstract class ContentAction {
    @ApiModelProperty(value="<p>\"parameters | change | approval\", depending on the type, different information will be provided.</p><p> See ParametersAction, ChangeAction or ApprovalAction subtypes</p>", dataType="string")
    public String type;
    @ApiModelProperty(value="<p>List of available actions depending on the action type:</p><ul><li>If type is \"approval\" some of the following available: approve, reject, assign, unassign</li><li>If type is \"change\": change</li></ul>")
    public List<String> actions;

    public ContentAction() {
    }

    public ContentAction(String type) {
        this.type = type;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @ApiModel(description="Approval action with related information about the approval itself")
    public static class ApprovalAction
    extends ContentAction {
        @ApiModelProperty(value="Approval's name", dataType="string", example="Review")
        public String name;
        @ApiModelProperty(value="Approval's short name", dataType="string", example="Review")
        public String shortName;
        @ApiModelProperty(dataType="string")
        public String instructions;
        @ApiModelProperty(value="<p>The signature mode for the approval:</p><ul><li>PASSWORD: Only password required (set with \"1\" in \"credentials\" param in <a href=\"https://apps.appf.re/cdmdc/doc/approvalmacro/wdIZvh\">\"approval\" macro</a>)</li><li>USERID_AND_PASSWORD: User name and password required (set with \"2\" in \"credentials\" param in <a href=\"https://apps.appf.re/cdmdc/doc/approvalmacro/wdIZvh\">\"approval\" macro</a>)</li></ul>", dataType="string", example="PASSWORD")
        public String signature;
        @ApiModelProperty(value="<p>The e-signature type used for the approval:</p><ul><li>CONFLUENCE: Confluence credentials authentication</li><li>OTP: One-Time Password authentication</li></ul>", dataType="string", example="CONFLUENCE")
        public String eSignature;
        @ApiModelProperty(value="List of involved users")
        public List<User> involvedUsers;
        @ApiModelProperty(value="If the comment action is mandatory", dataType="boolean", example="false")
        public boolean requiresComment;
        @ApiModelProperty(value="If the user has a signing token configured, relevant only when eSignature attribute is OTP", dataType="boolean", example="false")
        public boolean hasSigning;

        public ApprovalAction() {
            super("approval");
        }

        public ApprovalAction(String name, String shortName, List<String> actions, String instructions, String signature, String eSignature, List<User> involvedUsers, boolean requiresComment, boolean hasSigning) {
            this();
            this.name = name;
            this.shortName = shortName;
            this.actions = actions;
            this.instructions = instructions;
            this.signature = signature;
            this.eSignature = eSignature;
            this.involvedUsers = involvedUsers;
            this.requiresComment = requiresComment;
            this.hasSigning = hasSigning;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @ApiModel(description="Action to change to a different state")
    public static class ChangeAction
    extends ContentAction {
        @ApiModelProperty(value="List of valid states to transition to")
        public List<String> states;

        public ChangeAction() {
            super("change");
        }

        public ChangeAction(String ... state) {
            this(Arrays.asList(state));
        }

        public ChangeAction(List<String> states) {
            this();
            this.actions = Arrays.asList("change");
            this.states = states;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @ApiModel(description="Action for parameters input")
    public static class ParametersAction
    extends ContentAction {
        @ApiModelProperty(value="Information related to the parameter's input fields")
        public List<InputField> inputFields;
        @ApiModelProperty(value="True if page parameter values have to be initialized", dataType="boolean", required=true, example="false")
        public boolean isInit;

        public ParametersAction() {
            super("parameters");
        }

        public ParametersAction(List<InputField> inputFields, boolean isInit) {
            this();
            this.inputFields = inputFields;
            this.isInit = isInit;
        }
    }
}

