/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.mywork.listener;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.WorkflowUserSettingsManager;
import com.comalatech.confluence.workflow.mywork.AdhocInAppNotificationService;
import com.comalatech.confluence.workflow.mywork.notification.state.StateAssigneeNotification;
import com.comalatech.confluence.workflow.mywork.notification.state.StateChangeNotification;
import com.comalatech.confluence.workflow.mywork.notification.state.StateUnassignNotification;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.workflow.event.ContentAssignEvent;
import com.comalatech.workflow.event.ContentUnassignEvent;
import com.comalatech.workflow.event.StateChangeEvent;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StateMyWorkNotificationListener
extends WorkflowsListener {
    private static final Logger log = LoggerFactory.getLogger(StateMyWorkNotificationListener.class);
    protected final AdhocInAppNotificationService adhocInAppNotificationService;
    protected final AdhocNotificationService adhocNotificationService;
    protected final WorkflowUserSettingsManager workflowUserSettingsManager;
    protected final WorkflowPermissionManager workflowPermissionManager;
    protected final UserAccessor userAccessor;

    public StateMyWorkNotificationListener(@ComponentImport EventPublisher eventPublisher, AdhocInAppNotificationService adhocInAppNotificationService, AdhocNotificationService adhocNotificationService, WorkflowUserSettingsManager workflowUserSettingsManager, WorkflowPermissionManager workflowPermissionManager, @ComponentImport UserAccessor userAccessor) {
        super(eventPublisher);
        this.adhocInAppNotificationService = adhocInAppNotificationService;
        this.adhocNotificationService = adhocNotificationService;
        this.workflowUserSettingsManager = workflowUserSettingsManager;
        this.workflowPermissionManager = workflowPermissionManager;
        this.userAccessor = userAccessor;
    }

    @EventListener
    public void pageStateAssigned(ContentAssignEvent event) {
        StateAssigneeNotification notification = new StateAssigneeNotification(event);
        ArrayList<String> assignees = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)event.getAssignment().getAssignee())) {
            assignees.add(event.getAssignment().getAssignee());
        }
        this.adhocInAppNotificationService.sendNotification(notification, assignees);
    }

    @EventListener
    public void pageStateUnassigned(ContentUnassignEvent event) {
        StateUnassignNotification notification = new StateUnassignNotification(event);
        ArrayList<String> unassignees = new ArrayList<String>();
        if (event.getAssignment() != null && StringUtils.isNotBlank((CharSequence)event.getAssignment().getAssignee())) {
            unassignees.add(event.getAssignment().getAssignee());
        }
        this.adhocInAppNotificationService.sendNotification(notification, unassignees);
    }

    @EventListener
    public void pageStateChanged(StateChangeEvent event) {
        StateChangeNotification notification = new StateChangeNotification(event);
        if (event.getState().isPublished() || event.getPreviousEvent() != null && event.getPreviousEvent().isPublished()) {
            Set<ConfluenceUser> users = this.adhocNotificationService.getContentWatchers((AbstractPage)event.getContent(), null, false, null, null);
            ArrayList<String> notifyUsers = new ArrayList<String>();
            for (ConfluenceUser user : users) {
                if (!this.workflowPermissionManager.canViewDrafts((AbstractPage)event.getContent(), user) || !this.workflowUserSettingsManager.isInAppNotifyWatchedPages(user) || !this.sendSelfNotification(user)) continue;
                log.debug("pageStateChanged: Adding user: " + user.getName() + " to the notifications list for the event: " + event);
                notifyUsers.add(user.getName());
            }
            this.adhocInAppNotificationService.sendNotification(notification, notifyUsers);
        }
    }

    protected boolean sendSelfNotification(ConfluenceUser user) {
        if (user == null) {
            return false;
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser != null && currentUser.getName().equals(user.getName())) {
            return this.adhocNotificationService.getUserNotifyOwnActions(user);
        }
        return true;
    }
}

