/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import org.springframework.util.StringUtils;

public class HasLabelCondition
extends Condition {
    protected Label[] labels;

    public HasLabelCondition(boolean not, Label[] labels) {
        super(not);
        this.labels = labels;
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) throws WorkflowException {
        AbstractPage page = valueStore.getPage();
        return this.hasLabel(page);
    }

    protected boolean hasLabel(AbstractPage page) {
        for (Label label : this.labels) {
            if (!page.getLabels().contains(label)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        macro.addParameter("haslabel", (Object)((this.not ? "!" : "") + this.toString(this.labels)));
    }

    public Label[] getLabels() {
        return this.labels;
    }

    protected String toString(Label[] labels) {
        StringBuffer sb = new StringBuffer();
        String separator = "";
        for (Label label : labels) {
            sb.append(separator).append(label.getName());
            separator = ",";
        }
        return sb.toString();
    }

    @Override
    public String toString(ValueStore valueStore) {
        StringBuffer sb = new StringBuffer();
        Object list = StringUtils.arrayToCommaDelimitedString((Object[])this.labels);
        if (this.labels.length > 1) {
            int i = ((String)list).lastIndexOf(",");
            list = ((String)list).substring(0, i) + ((String)list).substring(i).replaceAll(",", "}} or {{");
        }
        if (this.not) {
            sb.append("does not have label {{");
        } else {
            sb.append("has label {{");
        }
        sb.append((String)list).append("}}");
        return sb.toString();
    }

    public String toString() {
        return this.toString((ValueStore)null);
    }
}

