/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.sal.api.component.ComponentLocator;

public class RenderUtils {
    public static String renderContent(ContentEntityObject ceo, RenderContext renderContext) throws Exception {
        DefaultConversionContext context = new DefaultConversionContext(renderContext);
        context.setProperty("releaseview", renderContext.getParam((Object)"releaseview"));
        BodyType bodyType = ceo.getBodyContent().getBodyType();
        if (BodyType.XHTML.equals((Object)bodyType)) {
            Renderer renderer = (Renderer)ComponentLocator.getComponent(Renderer.class, (String)"viewRenderer");
            return renderer.render(ceo, (ConversionContext)context);
        }
        if (BodyType.WIKI.equals((Object)bodyType)) {
            WikiStyleRenderer wikiStyleRenderer = (WikiStyleRenderer)ComponentLocator.getComponent(WikiStyleRenderer.class);
            return wikiStyleRenderer.convertWikiToXHtml(renderContext, RenderUtils.getContent(ceo));
        }
        throw new Exception("Unkown body content type: " + bodyType);
    }

    public static String renderContent(PageTemplate pageTemplate, RenderContext renderContext) {
        BodyType bodyType;
        try {
            bodyType = pageTemplate.getBodyType();
        }
        catch (NoSuchMethodError e) {
            bodyType = BodyType.WIKI;
        }
        if (BodyType.XHTML.equals((Object)bodyType)) {
            DefaultConversionContext context = new DefaultConversionContext(renderContext);
            for (Object propertyKey : renderContext.getParams().keySet()) {
                if (!(propertyKey instanceof String)) continue;
                context.setProperty((String)propertyKey, renderContext.getParam(propertyKey));
            }
            Renderer renderer = (Renderer)ComponentLocator.getComponent(Renderer.class, (String)"viewRenderer");
            return renderer.render(pageTemplate.getContent(), (ConversionContext)context);
        }
        WikiStyleRenderer wikiStyleRenderer = (WikiStyleRenderer)ComponentLocator.getComponent(WikiStyleRenderer.class);
        return wikiStyleRenderer.convertWikiToXHtml(renderContext, pageTemplate.getContent());
    }

    public static String getContent(ContentEntityObject ceo) {
        return ceo.getBodyContent().getBody();
    }

    public static String sanitizeBlock(String renderBody) {
        return renderBody.replaceAll("(?!>)(?:<|`>|/>)", "");
    }
}

