/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import com.comalatech.confluence.workflow.audit.model.WorkflowAuditLegacyRecord;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;

public class JsonSerialiserUtil<T> {
    private final Gson gsonSerializer = new Gson();
    private final Type listType;
    final TypeTokenFactory typeTokenFactory = new TypeTokenFactory();

    public JsonSerialiserUtil(Class<T> clazz) {
        this.listType = this.typeTokenFactory.getListType(clazz);
    }

    public String serialiseList(List<T> l) {
        return this.gsonSerializer.toJson(l);
    }

    public List<T> deserialiseList(String json) {
        return (List)this.gsonSerializer.fromJson(json, this.listType);
    }

    static class TypeTokenFactory {
        TypeTokenFactory() {
        }

        Type getListType(Class clazz) {
            if (clazz.getName().equals(WorkflowAuditLegacyRecord.class.getName())) {
                return new TypeToken<List<WorkflowAuditLegacyRecord>>(){}.getType();
            }
            return null;
        }
    }
}

