/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.service;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.messaging.Message;
import com.comalatech.confluence.messaging.PageMessageManager;
import com.comalatech.confluence.readack.ReadAckException;
import com.comalatech.confluence.readack.activeObjects.entity.BaseReadAckRecord;
import com.comalatech.confluence.readack.events.ReadAckCompletedEventImpl;
import com.comalatech.confluence.readack.events.ReadAckCreatedEventImpl;
import com.comalatech.confluence.readack.events.ReadAckOverdueEventImpl;
import com.comalatech.confluence.readack.events.ReadAckOverdueNotificationEvent;
import com.comalatech.confluence.readack.events.stats.ReadAckSupressReadConfirmation;
import com.comalatech.confluence.readack.model.ReadAckConfig;
import com.comalatech.confluence.readack.model.ReadAckPage;
import com.comalatech.confluence.readack.model.ReadAckStatusType;
import com.comalatech.confluence.readack.service.ReadAckConfigManager;
import com.comalatech.confluence.readack.service.ReadAckManager;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.util.RenderUtils;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.AbstractUserGroupApproverCondition;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.GroupCondition;
import com.comalatech.confluence.workflow.model.UserCondition;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DefaultReadAckConfigManager
implements ReadAckConfigManager,
ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultReadAckConfigManager.class);
    public static final Integer STANDALONE_READACK_PAGESTATE_ID = -1;
    public static final String SUPPRESS_READ_CONFIRMATION = "supressReadConfirmation";
    private ApplicationContext applicationContext;
    private final EventPublisher eventPublisher;
    private final ComalaPropertiesSetManager contentPropertyManager;
    private final WorkflowAccessor workflowAccessor;
    private final ConfluenceIndexer confluenceIndexer;
    private final PageMessageManager pageMessageManager;
    private final UserAccessor userAccessor;
    private final StateAccessor stateAccessor;
    private ReadAckManager readAckManager;
    private final String READ_ACK_CONFIG_KEY;

    public DefaultReadAckConfigManager(@ComponentImport EventPublisher eventPublisher, ComalaPropertiesSetManager contentPropertyManager, WorkflowAccessor workflowAccessor, WorkflowsFeatureManager workflowsFeatureManager, @ComponentImport ConfluenceIndexer confluenceIndexer, PageMessageManager pageMessageManager, @ComponentImport UserAccessor userAccessor, StateAccessor stateAccessor) {
        this.eventPublisher = eventPublisher;
        this.contentPropertyManager = contentPropertyManager;
        this.workflowAccessor = workflowAccessor;
        this.confluenceIndexer = confluenceIndexer;
        this.pageMessageManager = pageMessageManager;
        this.userAccessor = userAccessor;
        this.stateAccessor = stateAccessor;
        this.READ_ACK_CONFIG_KEY = "com.comalatech.workflow" + ".read-ack";
    }

    public void afterPropertiesSet() throws Exception {
        this.readAckManager = (ReadAckManager)this.applicationContext.getBean(ReadAckManager.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public ReadAckConfig setupReadAckConfig(ReadAckPage readAckPage) {
        ReadAckConfig readAckConfig;
        block5: {
            readAckConfig = null;
            String suppressReadConfirmationAsString = this.contentPropertyManager.getStringProperty((ContentEntityObject)readAckPage.getPage(), SUPPRESS_READ_CONFIRMATION);
            boolean suppressNotifications = BooleanUtils.toBoolean((String)suppressReadConfirmationAsString);
            try {
                List<Map.Entry<ConfluenceUser, BaseReadAckRecord.ReadAckAssignmentType>> usersSet;
                readAckConfig = this.loadReadAckConfig(readAckPage.getPage());
                PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(readAckPage.getPage());
                if (suppressNotifications) break block5;
                try {
                    usersSet = this.resolveUsersFromConditions(readAckPage, pageWorkflows);
                }
                catch (WorkflowException e) {
                    throw new ReadAckException(e.getMessage());
                }
                if (readAckConfig != null) {
                    this.readAckManager.appendManualUsers(readAckConfig, usersSet);
                    this.readAckManager.closePendingReadAcks(readAckConfig);
                }
                readAckConfig = this.buildNewReadAckConfigInstance(readAckPage, pageWorkflows);
                this.saveReadAckConfig(readAckPage.getPage(), readAckConfig);
                this.readAckManager.setupUsersReadAck(usersSet, readAckConfig);
                this.eventPublisher.publish((Object)new ReadAckCreatedEventImpl(this, readAckPage.getPage(), usersSet.stream().map(Map.Entry::getKey).collect(Collectors.toSet())));
            }
            catch (ReadAckException e) {
                log.error("There was an error while creating the Read Acknowledgement: " + readAckPage, (Throwable)e);
                this.logMessage(readAckPage.getPage(), e.getMessage());
            }
        }
        return readAckConfig;
    }

    private void logMessage(AbstractPage page, String message) {
        this.pageMessageManager.setMessage(page, "Error creating Read Confirmation for the page", AuthenticatedUserThreadLocal.get(), "Solve the following problem : " + RenderUtils.sanitizeBlock(message) + ", then approve the page again to create the read confirmation.", Message.MacroParamStyle.WARNING.param, 20L);
    }

    @Override
    @Nullable
    public ReadAckConfig loadReadAckConfig(AbstractPage page) throws ReadAckException {
        return this.loadReadAckConfig(page, false);
    }

    @Override
    @Nullable
    public ReadAckConfig loadReadAckConfig(AbstractPage page, boolean initialise) throws ReadAckException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String readAckJsonString = this.contentPropertyManager.getStringProperty((ContentEntityObject)page, this.READ_ACK_CONFIG_KEY);
            ReadAckConfig readAckConfig = StringUtils.isNotBlank((CharSequence)readAckJsonString) ? mapper.readValue(readAckJsonString, ReadAckConfig.class) : null;
            PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
            if (readAckConfig == null && initialise && pageWorkflows != null) {
                readAckConfig = pageWorkflows.isStandAloneReadAck() ? this.setupReadAckConfig(new ReadAckPage(page, null, pageWorkflows.getReadAck())) : null;
            }
            return readAckConfig;
        }
        catch (IOException e) {
            log.error("There was an error while loading the Read Acknowledgment");
            throw new ReadAckException(e);
        }
    }

    @Override
    public void setReadAckAsCompleted(AbstractPage page, ReadAckConfig readAckConfig, Long ackTimestamp) throws ReadAckException {
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        readAckConfig.status = ReadAckStatusType.PageStatusType.ACKNOWLEDGED;
        this.saveReadAckConfig(page, readAckConfig);
        this.eventPublisher.publish((Object)new ReadAckCompletedEventImpl(this, page, ackTimestamp, pageWorkflows.getValueStore().getPageState()));
        this.confluenceIndexer.reIndex((Searchable)page);
    }

    @Override
    public void setReadAckAsOverdue(AbstractPage page, ReadAckConfig readAckConfig) throws ReadAckException {
        readAckConfig.status = ReadAckStatusType.PageStatusType.OVERDUE;
        this.saveReadAckConfig(page, readAckConfig);
        this.eventPublisher.publish((Object)new ReadAckOverdueEventImpl(this, page));
        this.confluenceIndexer.reIndex((Searchable)page);
    }

    @Override
    public void sendNotificationOverdue(AbstractPage page) {
        this.eventPublisher.publish((Object)new ReadAckOverdueNotificationEvent(this, page));
    }

    @Override
    public void reopenReadAck(AbstractPage page, ReadAckConfig readAckConfig) throws ReadAckException {
        readAckConfig.status = ReadAckStatusType.PageStatusType.PENDING;
        this.saveReadAckConfig(page, readAckConfig);
        this.confluenceIndexer.reIndex((Searchable)page);
    }

    @Override
    public ReadAckConfig resetReadAckConfig(AbstractPage page, ReadAckConfig readAckConfig) throws ReadAckException {
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (pageWorkflows == null) {
            throw new ReadAckException("No workflows found on page " + page.getId());
        }
        PageState pageState = this.stateAccessor.getLatestState(page);
        if (!(pageWorkflows.isStandAloneReadAck() || pageState != null && pageState.getId() == readAckConfig.pageStateId.intValue())) {
            throw new ReadAckException("State " + readAckConfig.pageStateId + " not found for read confirmation on page " + page.getId());
        }
        if (pageWorkflows.getReadAck() == null) {
            throw new ReadAckException("ReadAck object is null in the Workflows for page " + page.getId());
        }
        ReadAckPage readAckPage = new ReadAckPage(page, pageState, pageWorkflows.getReadAck());
        readAckConfig = this.buildNewReadAckConfigInstance(readAckPage, pageWorkflows);
        this.saveReadAckConfig(page, readAckConfig);
        this.confluenceIndexer.reIndex((Searchable)page);
        return readAckConfig;
    }

    @Override
    public void removeReadAckConfig(AbstractPage page) {
        this.contentPropertyManager.removeProperty((ContentEntityObject)page, this.READ_ACK_CONFIG_KEY);
    }

    @Override
    public void updateReadAckConfig(AbstractPage page, ReadAckConfig readAckConfig) throws ReadAckException {
        this.saveReadAckConfig(page, readAckConfig);
    }

    @Override
    public void setSuppressNotificationValue(AbstractPage page, Boolean suppressNotificationEnabled) {
        this.contentPropertyManager.setStringProperty((ContentEntityObject)page, SUPPRESS_READ_CONFIRMATION, String.valueOf(suppressNotificationEnabled));
        if (Boolean.TRUE.equals(suppressNotificationEnabled)) {
            this.eventPublisher.publish((Object)new ReadAckSupressReadConfirmation(this));
        }
    }

    @Override
    public Boolean getSuppressNotificationValue(AbstractPage page) {
        String supressNotificationValue = this.contentPropertyManager.getStringProperty((ContentEntityObject)page, SUPPRESS_READ_CONFIRMATION);
        if (supressNotificationValue == null) {
            return null;
        }
        return BooleanUtils.toBoolean((String)supressNotificationValue);
    }

    private void saveReadAckConfig(AbstractPage page, ReadAckConfig readAckConfig) throws ReadAckException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.contentPropertyManager.setStringProperty((ContentEntityObject)page, this.READ_ACK_CONFIG_KEY, mapper.writeValueAsString(readAckConfig));
        }
        catch (IOException e) {
            throw new ReadAckException(e);
        }
    }

    private ReadAckConfig buildNewReadAckConfigInstance(ReadAckPage readAckPage, PageWorkflows pageWorkflows) throws ReadAckException {
        try {
            String dueDateStr = pageWorkflows.getValueStore().getValue(readAckPage.getReadAck().getDueDate());
            DateTime now = DateTime.now();
            Long dueDate = null;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dueDateStr})) {
                dueDate = now.plus(TimerUtils.parsePeriod(dueDateStr)).getMillis();
            }
            Integer pageStateId = readAckPage.getPageState() != null ? readAckPage.getPageState().getId() : STANDALONE_READACK_PAGESTATE_ID.intValue();
            return new ReadAckConfig(readAckPage.getPage().getId(), readAckPage.getPage().getVersion(), pageStateId, now.getMillis(), dueDate, pageWorkflows.getReadAck().isChangeDueDate());
        }
        catch (WorkflowException e) {
            String errMsg = "Value of the value reference used to set the due date into the read confirmation is not valid: " + readAckPage.getReadAck().getDueDate();
            log.error(errMsg, (Throwable)e);
            throw new ReadAckException(errMsg, e);
        }
    }

    private List<Map.Entry<ConfluenceUser, BaseReadAckRecord.ReadAckAssignmentType>> resolveUsersFromConditions(ReadAckPage readAckPage, PageWorkflows pageWorkflows) throws WorkflowException {
        HashSet<1> usersSet = new HashSet<1>();
        for (Condition condition : readAckPage.getReadAck().getConditions()) {
            ConfluenceUser[] users;
            if (!(condition instanceof UserCondition) && !(condition instanceof GroupCondition)) continue;
            for (ConfluenceUser user : users = ((AbstractUserGroupApproverCondition)condition).getSelectableUsers(pageWorkflows.getValueStore(), null, true)) {
                if (this.userAccessor.isDeactivated((User)user)) continue;
                usersSet.add(new AbstractMap.SimpleEntry<ConfluenceUser, BaseReadAckRecord.ReadAckAssignmentType>(user, BaseReadAckRecord.ReadAckAssignmentType.PARAMETER){});
            }
        }
        ArrayList<Map.Entry<ConfluenceUser, BaseReadAckRecord.ReadAckAssignmentType>> usersList = new ArrayList<Map.Entry<ConfluenceUser, BaseReadAckRecord.ReadAckAssignmentType>>(usersSet);
        return usersList;
    }
}

