/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.encryption;

import com.comalatech.confluence.encryption.AESEncryptionException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESEncryption {
    public static String encrypt(String plainText, String key) throws AESEncryptionException {
        try {
            byte[] clean = plainText.getBytes();
            int ivSize = 16;
            byte[] iv = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(key.getBytes("UTF-8"));
            byte[] keyBytes = new byte[16];
            System.arraycopy(digest.digest(), 0, keyBytes, 0, keyBytes.length);
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            byte[] encrypted = cipher.doFinal(clean);
            byte[] encryptedIVAndText = new byte[16 + encrypted.length];
            System.arraycopy(iv, 0, encryptedIVAndText, 0, 16);
            System.arraycopy(encrypted, 0, encryptedIVAndText, 16, encrypted.length);
            return Base64.getEncoder().encodeToString(encryptedIVAndText);
        }
        catch (Exception ex) {
            throw new AESEncryptionException(ex.getMessage());
        }
    }

    public static String decrypt(String encryptedIvText, String key) throws AESEncryptionException {
        try {
            int ivSize = 16;
            int keySize = 16;
            byte[] encryptedIvTextBytes = Base64.getDecoder().decode(encryptedIvText);
            byte[] iv = new byte[16];
            System.arraycopy(encryptedIvTextBytes, 0, iv, 0, iv.length);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            int encryptedSize = encryptedIvTextBytes.length - 16;
            byte[] encryptedBytes = new byte[encryptedSize];
            System.arraycopy(encryptedIvTextBytes, 16, encryptedBytes, 0, encryptedSize);
            byte[] keyBytes = new byte[16];
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(key.getBytes());
            System.arraycopy(md.digest(), 0, keyBytes, 0, keyBytes.length);
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "AES");
            Cipher cipherDecrypt = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipherDecrypt.init(2, (Key)secretKeySpec, ivParameterSpec);
            byte[] decrypted = cipherDecrypt.doFinal(encryptedBytes);
            return new String(decrypted);
        }
        catch (Exception ex) {
            throw new AESEncryptionException(ex.getMessage());
        }
    }
}

