/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.service.mapper;

import com.atlassian.confluence.api.model.longtasks.LongTaskId;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.user.User;
import com.comalatech.confluence.documentActivity.upgrade.accessor.entity.UpgradeTaskRecord;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.Status;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.UpgradeTask;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;

public class UpgradeTaskMapper {
    private final LongRunningTaskManager longRunningTaskManager;
    public static final String SUPPORT_DOWNLOAD_LINK = "/rest/cw/2/documentactivity/upgrade/support/";

    public UpgradeTaskMapper(LongRunningTaskManager longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }

    public UpgradeTask fromRecordToModel(UpgradeTaskRecord upgradeTaskRecord, Space space) {
        UpgradeTask upgradeTask = new UpgradeTask();
        if (upgradeTaskRecord != null) {
            upgradeTask.setStatus(upgradeTaskRecord.getStatus());
            upgradeTask.setDuration(upgradeTaskRecord.getDuration());
            upgradeTask.setNumErrors(upgradeTaskRecord.getNumErrors());
            upgradeTask.setStartedAt(upgradeTaskRecord.getStartedAt());
            String taskId = upgradeTaskRecord.getLongRunningTaskId();
            if (!Status.UPGRADE_SUCCESS.equals((Object)upgradeTask.getStatus()) && !Status.NOT_RUN.equals((Object)upgradeTask.getStatus()) && taskId != null) {
                LongRunningTaskId longRunningTaskId = LongRunningTaskId.from((LongTaskId)LongTaskId.deserialise((String)taskId));
                LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), longRunningTaskId);
                if (longRunningTask != null) {
                    upgradeTask.setProgress(longRunningTask.getPercentageComplete());
                    if (Status.UPGRADE_IN_PROGRESS.equals((Object)upgradeTaskRecord.getStatus()) || Status.REVERT_IN_PROGRESS.equals((Object)upgradeTaskRecord.getStatus())) {
                        upgradeTask.setPhase(longRunningTask.getCurrentStatus());
                    }
                }
            }
            if (Status.UPGRADE_FAIL.equals((Object)upgradeTaskRecord.getStatus()) || Status.FAIL.equals((Object)upgradeTaskRecord.getStatus())) {
                upgradeTask.setSupport(SUPPORT_DOWNLOAD_LINK + space.getKey());
            }
        } else {
            upgradeTask.setStatus(Status.NOT_RUN);
        }
        return upgradeTask;
    }

    public UpgradeTaskRecord fromModelToRecord(UpgradeTask upgradeTask) {
        UpgradeTaskRecord upgradeTaskRecord = new UpgradeTaskRecord();
        if (upgradeTask != null) {
            upgradeTaskRecord.setStatus(upgradeTask.getStatus());
            upgradeTaskRecord.setDuration(upgradeTask.getDuration());
            upgradeTaskRecord.setNumErrors(upgradeTask.getNumErrors());
            upgradeTaskRecord.setLongRunningTaskId(upgradeTask.getLongRunningTaskId());
            upgradeTaskRecord.setStartedAt(upgradeTask.getStartedAt());
        }
        return upgradeTaskRecord;
    }
}

