/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.resources;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.ContentUpgrade;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.SpaceUpgrade;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.Status;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.Upgrade;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.UpgradeMetadata;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.UpgradeTask;
import com.comalatech.confluence.documentActivity.upgrade.manager.SpaceUpgradeManager;
import com.comalatech.confluence.documentActivity.upgrade.resources.AbstractSpaceUpgradeResource;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestContentUpgradeRunRequest;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestContentUpgradeRunResponse;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestSpaceRevertUpgradeRequest;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestSpaceRevertUpgradeResponse;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestSpaceUpgrade;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestSpaceUpgradeCancelRequest;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestSpaceUpgradeRunRequest;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestSpaceUpgradeRunResponse;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestSpaceUpgradeTask;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestUpgradeMetadata;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestUpgradeResponse;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Api(value="/documentactivity", produces="application/json")
@Path(value="/documentactivity/upgrade")
@Produces(value={"application/json"})
public class SpaceUpgradeResource
extends AbstractSpaceUpgradeResource {
    private static final Logger log = LoggerFactory.getLogger(SpaceUpgradeResource.class);
    private final DocumentActivityUpgradeService documentActivityUpgradeService;
    private final SpaceUpgradeManager spaceUpgradeManager;
    private final AccessModeService accessModeService;

    @Inject
    public SpaceUpgradeResource() {
        this.documentActivityUpgradeService = PluginContainerManager.getComponent(DocumentActivityUpgradeService.class);
        this.spaceUpgradeManager = PluginContainerManager.getComponent(SpaceUpgradeManager.class);
        this.accessModeService = PluginContainerManager.getComponent(AccessModeService.class);
    }

    @Autowired
    public SpaceUpgradeResource(DocumentActivityUpgradeService documentActivityUpgradeService, WorkflowsFeatureManager workflowsFeatureManager, @ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, SpaceUpgradeManager spaceUpgradeManager, @ComponentImport AccessModeService accessModeService, @ComponentImport PageManager pageManager, ComalaI18nBean comalaI18nBean) {
        super(permissionManager, spaceManager, workflowsFeatureManager, pageManager, comalaI18nBean);
        this.documentActivityUpgradeService = documentActivityUpgradeService;
        this.spaceUpgradeManager = spaceUpgradeManager;
        this.accessModeService = accessModeService;
    }

    @GET
    @Path(value="/report")
    @PermissionRequired(value={"ADMINISTER"})
    @ApiOperation(value="Retrieves the upgrade report, giving the information about the spaces with workflows and their respective statistics.", response=RestUpgradeResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The upgrade report is generated and returned."), @ApiResponse(code=500, message="Something went wrong, unable to retrieve space upgrade report."), @ApiResponse(code=401, message="The application has no permission over this method"), @ApiResponse(code=403, message="The given user does not have access.")})
    public Response getUpgradesReport(final @QueryParam(value="start") int start, final @QueryParam(value="limit") int limit) {
        return new AbstractSpaceUpgradeResource.RestCommand(){

            @Override
            public Response doExecute() {
                try {
                    return Response.ok().entity((Object)SpaceUpgradeResource.this.buildUpgradeReportingResponse(SpaceUpgradeResource.this.documentActivityUpgradeService.getUpgradeData(start, limit))).type("application/json").build();
                }
                catch (Exception e) {
                    log.error("Unable to retrieve space upgrade report.", (Throwable)e);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", SpaceUpgradeResource.this.comalaI18nBean.getText("comalatech.upgrade.checks.reporting.error"));
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }

    @GET
    @Path(value="/status/{spaceKey}")
    @PermissionRequired(value={"ADMINISTER"})
    @ApiOperation(value="Retrieves the space upgrade/pre-check status of the space provided.", response=RestSpaceUpgradeTask.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The space upgrade/pre-check status is returned."), @ApiResponse(code=500, message="Something went wrong, Unable to retrieve the space pre-check status."), @ApiResponse(code=401, message="The application has no permission over this method"), @ApiResponse(code=403, message="The given user does not have access.")})
    public Response getSpaceUpgradeStatus(@ApiParam(value="Space key to get upgrade/pre-check data", required=true, example="spacekey") @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractSpaceUpgradeResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    Space space = (Space)this.getValidationTarget();
                    UpgradeTask upgradeTask = SpaceUpgradeResource.this.documentActivityUpgradeService.getSpaceUpgrade(space);
                    return Response.ok().entity((Object)SpaceUpgradeResource.this.buildUpgradeTaskResponse(space, upgradeTask)).type("application/json").build();
                }
                catch (Exception e) {
                    log.error("Unable to retrieve the space pre-check status.", (Throwable)e);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", SpaceUpgradeResource.this.comalaI18nBean.getText("comalatech.upgrade.checks.reporting.error"));
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }

    @POST
    @Path(value="/run")
    @PermissionRequired(value={"ADMINISTER"})
    @ReadOnlyAccessAllowed
    @Consumes(value={"application/json"})
    @ApiOperation(value="Run the space upgrade/pre-check task given a list of space keys to upgrade", response=RestSpaceUpgradeRunResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The upgrade task is running for the list of given spaces."), @ApiResponse(code=500, message="Something went wrong, unable to run the space upgrade task."), @ApiResponse(code=400, message="The given space key does not exist."), @ApiResponse(code=401, message="The application has no permission over this method"), @ApiResponse(code=403, message="The given user does not have access.")})
    public Response runSpaceUpgrade(final @ApiParam(name="Space Upgrade request") RestSpaceUpgradeRunRequest spaceUpgradeRun) {
        return new AbstractSpaceUpgradeResource.RestCommand(){

            @Override
            public Response doExecute() {
                try {
                    if (spaceUpgradeRun.isUpgrade() && !SpaceUpgradeResource.this.accessModeService.isReadOnlyAccessModeEnabled()) {
                        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                    }
                    if (spaceUpgradeRun.getSpaceKeys() == null || spaceUpgradeRun.getSpaceKeys().isEmpty()) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                    }
                    ArrayList<Space> spaces = new ArrayList<Space>();
                    for (String key : spaceUpgradeRun.getSpaceKeys()) {
                        Space space2 = SpaceUpgradeResource.this.spaceManager.getSpace(key);
                        if (space2 == null) {
                            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("The space key " + key + " does not exist")).build();
                        }
                        spaces.add(space2);
                    }
                    ArrayList<RestSpaceUpgradeTask> preChecks = new ArrayList<RestSpaceUpgradeTask>();
                    spaces.forEach(space -> {
                        RestSpaceUpgradeTask restSpaceUpgradeTask = SpaceUpgradeResource.this.buildUpgradeTaskResponse((Space)space, SpaceUpgradeResource.this.spaceUpgradeManager.launchSpaceUpgradeTask((Space)space, spaceUpgradeRun.isUpgrade()));
                        preChecks.add(restSpaceUpgradeTask);
                    });
                    return Response.ok().entity((Object)SpaceUpgradeResource.this.buildUpgradeRunResponse(preChecks)).type("application/json").build();
                }
                catch (Exception ex) {
                    log.error("Unable to run the space upgrade/pre-check task.", (Throwable)ex);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", SpaceUpgradeResource.this.comalaI18nBean.getText("comalatech.upgrade.checks.reporting.error"));
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }

    @POST
    @Path(value="/content/run")
    @PermissionRequired(value={"ADMINISTER"})
    @ReadOnlyAccessAllowed
    @Consumes(value={"application/json"})
    @ApiOperation(value="Run the content upgrade/pre-check task given a content id (Read Only Mode is not required)", response=RestContentUpgradeRunResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The content upgrade/pre-check task has been executed successfully."), @ApiResponse(code=400, message="The content id parameter is not provided or the space to which the page belongs to is not upgraded."), @ApiResponse(code=401, message="The application has no permission over this method."), @ApiResponse(code=403, message="The given user does not have access."), @ApiResponse(code=404, message="The given content id does not exist."), @ApiResponse(code=500, message="Something went wrong, unable to run the content upgrade/pre-check task.")})
    public Response runContentUpgrade(final @ApiParam(name="Page Upgrade request") RestContentUpgradeRunRequest contentUpgradeRun) {
        return new AbstractSpaceUpgradeResource.RestCommand(){

            @Override
            public Response doExecute() {
                try {
                    if (contentUpgradeRun.getContentId() == null) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Content id parameter has to be provided").build();
                    }
                    AbstractPage content = SpaceUpgradeResource.this.pageManager.getAbstractPage(contentUpgradeRun.getContentId().longValue());
                    if (content == null) {
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("The content with id " + contentUpgradeRun.getContentId() + " does not exist")).build();
                    }
                    UpgradeTask upgradeTask = SpaceUpgradeResource.this.documentActivityUpgradeService.getSpaceUpgrade(content.getSpace());
                    if (Status.UPGRADE_SUCCESS.equals((Object)upgradeTask.getStatus()) || !contentUpgradeRun.isUpgrade()) {
                        ContentUpgrade contentUpgrade = SpaceUpgradeResource.this.spaceUpgradeManager.launchContentUpgradeTask(content, contentUpgradeRun.isUpgrade());
                        return Response.ok().entity((Object)SpaceUpgradeResource.this.buildContentUpgradeResponse(contentUpgrade)).type("application/json").build();
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("The content space which the page with id " + content.getId() + " belongs to is not upgraded")).type("application/json").build();
                }
                catch (Exception ex) {
                    log.error("Unable to run the content upgrade/pre-check task.", (Throwable)ex);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", SpaceUpgradeResource.this.comalaI18nBean.getText("comalatech.upgrade.checks.reporting.error"));
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }

    @POST
    @Path(value="/cancel")
    @PermissionRequired(value={"ADMINISTER"})
    @ReadOnlyAccessAllowed
    @Consumes(value={"application/json"})
    @ApiOperation(value="Cancels the running space upgrade/pre-check task for the space provided")
    @ApiResponses(value={@ApiResponse(code=200, message="Upgrade task successfully cancelled"), @ApiResponse(code=404, message="There is no upgrade process for the given space"), @ApiResponse(code=500, message="Something went wrong, unable to cancel the space upgrade task."), @ApiResponse(code=401, message="The application has no permission over this method"), @ApiResponse(code=403, message="The given user does not have access.")})
    public Response cancelSpaceUpgrade(final @ApiParam(name="Space Upgrade/Pre-check task cancel request") RestSpaceUpgradeCancelRequest spaceUpgradeCancel) {
        return new AbstractSpaceUpgradeResource.RestSpaceCommand(spaceUpgradeCancel.getSpaceKey()){

            @Override
            public Response doExecute() {
                try {
                    Space space = (Space)this.getValidationTarget();
                    UpgradeTask upgradeTask = SpaceUpgradeResource.this.documentActivityUpgradeService.getSpaceUpgrade(space);
                    if (Status.getInProgressStatus(spaceUpgradeCancel.isUpgrade()).equals((Object)upgradeTask.getStatus())) {
                        SpaceUpgradeResource.this.spaceUpgradeManager.cancelSpaceUpgradeTask(space, spaceUpgradeCancel.isUpgrade());
                        return Response.ok().build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                catch (Exception e) {
                    log.error("Unable to cancel the space upgrade/pre-check status.", (Throwable)e);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", SpaceUpgradeResource.this.comalaI18nBean.getText("comalatech.upgrade.checks.reporting.error"));
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }

    @POST
    @Path(value="/revert")
    @PermissionRequired(value={"ADMINISTER"})
    @ReadOnlyAccessAllowed
    @Consumes(value={"application/json"})
    @ApiOperation(value="Revert the space upgrade task given the space key of and upgraded space", response=RestSpaceRevertUpgradeResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The revert task is running for the given space."), @ApiResponse(code=500, message="Something went wrong, unable to run the space revert task."), @ApiResponse(code=400, message="The given space key does not exist."), @ApiResponse(code=401, message="The application has no permission over this method"), @ApiResponse(code=403, message="The given user does not have access.")})
    public Response revertSpaceUpgrade(final @ApiParam(name="Revert Space Upgrade request") RestSpaceRevertUpgradeRequest request) {
        return new AbstractSpaceUpgradeResource.RestCommand(){

            @Override
            public Response doExecute() {
                try {
                    if (!SpaceUpgradeResource.this.accessModeService.isReadOnlyAccessModeEnabled()) {
                        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                    }
                    if (request.getSpaceKey() == null || request.getSpaceKey().isEmpty()) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                    }
                    Space space = SpaceUpgradeResource.this.spaceManager.getSpace(request.getSpaceKey());
                    if (space == null) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("The space key " + request.getSpaceKey() + " does not exist")).build();
                    }
                    RestSpaceUpgradeTask restSpaceRevertTask = SpaceUpgradeResource.this.buildRevertTaskResponse(space, SpaceUpgradeResource.this.spaceUpgradeManager.launchSpaceRevertTask(space));
                    return Response.ok().entity((Object)SpaceUpgradeResource.this.buildRevertRunResponse(restSpaceRevertTask)).type("application/json").build();
                }
                catch (Exception ex) {
                    log.error("Unable to run the space  revert upgrade task.", (Throwable)ex);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", SpaceUpgradeResource.this.comalaI18nBean.getText("comalatech.upgrade.checks.reporting.error"));
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }

    @GET
    @Path(value="/support/{spaceKey}")
    @PermissionRequired(value={"ADMINISTER"})
    @Produces(value={"application/octet-stream"})
    @ApiResponses(value={@ApiResponse(code=200, message="Support file is generated and returned"), @ApiResponse(code=400, message="Space key is null or does not exist"), @ApiResponse(code=403, message="User is not administrator"), @ApiResponse(code=404, message="No support package content"), @ApiResponse(code=500, message="Cannot generate support data"), @ApiResponse(code=401, message="The application has no permission over this method")})
    @ApiOperation(value="Get support file for the document activity upgrade")
    public Response getSupportFile(final @ApiParam(value="Space key to get upgrade/pre-check support package file", required=true, example="spacekey") @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractSpaceUpgradeResource.RestCommand(){

            @Override
            public Response doExecute() {
                try {
                    if (spaceKey == null) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                    }
                    Space space = SpaceUpgradeResource.this.spaceManager.getSpace(spaceKey);
                    if (space == null) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("The space key " + spaceKey + " does not exist")).build();
                    }
                    java.nio.file.Path supportFile = SpaceUpgradeResource.this.documentActivityUpgradeService.getSupportFile(space);
                    StreamingOutput stream = outputStream -> Files.copy(supportFile, outputStream);
                    return Response.ok((Object)stream, (String)"application/octet-stream").header("Content-Length", (Object)String.valueOf(Files.size(supportFile))).header("Content-Disposition", (Object)("attachment; filename=" + supportFile.getFileName().toString())).build();
                }
                catch (NoSuchFileException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.NOT_FOUND.getStatusCode());
                    error.put("message", SpaceUpgradeResource.this.comalaI18nBean.getText("comalatech.awp.global.workflows.upgrade.checks.reporting.support.error"));
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error.toString()).type("application/json").build();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", e.getMessage() != null ? e.getMessage() : "Internal server error");
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }

    private RestSpaceUpgradeRunResponse buildUpgradeRunResponse(List<RestSpaceUpgradeTask> preChecks) {
        RestSpaceUpgradeRunResponse restSpaceUpgradeRunResponse = new RestSpaceUpgradeRunResponse();
        restSpaceUpgradeRunResponse.setUpgradeTasks(preChecks);
        return restSpaceUpgradeRunResponse;
    }

    private RestSpaceRevertUpgradeResponse buildRevertRunResponse(RestSpaceUpgradeTask task) {
        RestSpaceRevertUpgradeResponse response = new RestSpaceRevertUpgradeResponse();
        response.setRevertTask(task);
        return response;
    }

    private RestSpaceUpgradeTask buildUpgradeTaskResponse(Space space, UpgradeTask upgradeTask) {
        RestSpaceUpgradeTask restSpaceUpgradeTask = new RestSpaceUpgradeTask(upgradeTask);
        restSpaceUpgradeTask.setSpaceKey(space.getKey());
        return restSpaceUpgradeTask;
    }

    private RestSpaceUpgradeTask buildRevertTaskResponse(Space space, UpgradeTask revertTask) {
        RestSpaceUpgradeTask restSpaceUpgradeTask = new RestSpaceUpgradeTask(revertTask);
        restSpaceUpgradeTask.setSpaceKey(space.getKey());
        return restSpaceUpgradeTask;
    }

    private RestUpgradeResponse buildUpgradeReportingResponse(Upgrade upgradeData) {
        RestUpgradeResponse response = new RestUpgradeResponse();
        ArrayList<RestSpaceUpgrade> restSpaceUpgrades = new ArrayList<RestSpaceUpgrade>();
        if (upgradeData != null) {
            List<SpaceUpgrade> spaceUpgrades = upgradeData.getSpaceUpgrades();
            for (SpaceUpgrade spaceUpgrade : spaceUpgrades) {
                RestSpaceUpgrade restSpaceUpgrade = new RestSpaceUpgrade(spaceUpgrade);
                restSpaceUpgrades.add(restSpaceUpgrade);
            }
        }
        response.setRestUpgradeMetadata(this.buildUpgradeReportingMetadata(upgradeData.getUpgradeMetadata()));
        response.setRestSpaceUpgradeList(restSpaceUpgrades);
        response.setReadOnlyMode(upgradeData.isReadOnlyMode());
        return response;
    }

    private RestUpgradeMetadata buildUpgradeReportingMetadata(UpgradeMetadata upgradeMetadata) {
        RestUpgradeMetadata restUpgradeMetadata = new RestUpgradeMetadata();
        if (upgradeMetadata != null) {
            restUpgradeMetadata.setHighestNumPagesWithWorkflowPerSpace(upgradeMetadata.getHighestNumPagesWithWorkflowPerSpace());
            restUpgradeMetadata.setMedianPagesWithWorkflowPerSpace(upgradeMetadata.getMedianPagesWithWorkflowPerSpace());
            restUpgradeMetadata.setTotalSpaces(upgradeMetadata.getTotalSpaces());
            restUpgradeMetadata.setTotalSpacesChecked(upgradeMetadata.getTotalSpacesChecked());
            restUpgradeMetadata.setTotalSpacesUpgraded(upgradeMetadata.getTotalSpacesUpgraded());
            restUpgradeMetadata.setLatestSpaceUpgraded(upgradeMetadata.getLatestSpaceUpgraded());
            restUpgradeMetadata.setTotalSpacesWithHistory(upgradeMetadata.getTotalSpacesWithHistory());
            restUpgradeMetadata.setTotalPagesWithHistory(upgradeMetadata.getTotalPagesWithHistory());
            restUpgradeMetadata.setTotalDocActivityEntries(upgradeMetadata.getTotalDocActivityEntries());
            restUpgradeMetadata.setTotalSpacesNeedUpgrade(upgradeMetadata.getTotalSpacesNeedUpgrade());
            restUpgradeMetadata.setStart(upgradeMetadata.getStart());
            restUpgradeMetadata.setLimit(upgradeMetadata.getLimit());
            restUpgradeMetadata.setHasMore(upgradeMetadata.isHasMore());
        }
        return restUpgradeMetadata;
    }

    private RestContentUpgradeRunResponse buildContentUpgradeResponse(ContentUpgrade contentUpgrade) {
        RestContentUpgradeRunResponse restContentUpgradeRunResponse = new RestContentUpgradeRunResponse();
        restContentUpgradeRunResponse.setContentId(contentUpgrade.getContentId());
        restContentUpgradeRunResponse.setSupport(contentUpgrade.getSupport());
        restContentUpgradeRunResponse.setStatus(contentUpgrade.getStatus().getValue());
        return restContentUpgradeRunResponse;
    }
}

