/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.statistics.validator;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.comalatech.confluence.documentActivity.statistics.validator.UsageStatsValidator;
import com.comalatech.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DefaultUsageStatsValidator
implements UsageStatsValidator {
    private final PermissionManager permissionManager;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;

    public DefaultUsageStatsValidator(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport UserAccessor userAccessor) {
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
    }

    @Override
    public List<Space> validateSpaces(List<String> spaceKeys) throws WorkflowException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            throw new WorkflowException("Forbidden: No user has been specified. Cannot perform validation.");
        }
        if (spaceKeys != null && !spaceKeys.isEmpty()) {
            for (String key : spaceKeys) {
                Space space = this.spaceManager.getSpace(key);
                if (space == null) {
                    throw new IllegalArgumentException("Invalid space key " + key);
                }
                if (!this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)space)) {
                    throw new WorkflowException("Forbidden: " + user.getName() + " has no admin permission over " + space.getName());
                }
                spaces.add(space);
            }
        } else if (!this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            throw new WorkflowException("Forbidden: " + user.getName() + " has no global admin permission. Cannot perform validation.");
        }
        return spaces;
    }

    @Override
    public void validateDates(Long fromDate, Long toDate) throws IllegalArgumentException {
        if (fromDate != null && toDate != null && fromDate >= toDate) {
            throw new IllegalArgumentException("fromDate must be greater than toDate parameter.");
        }
    }

    @Override
    public void validateState(String state) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)state)) {
            throw new IllegalArgumentException("state parameter must be non empty.");
        }
    }

    @Override
    public void validateApprovalName(String approvalName) {
        if (StringUtils.isEmpty((CharSequence)approvalName)) {
            throw new IllegalArgumentException("approvalName parameter must be non empty.");
        }
    }

    @Override
    public void validateAssignee(String assignee) {
        if (StringUtils.isEmpty((CharSequence)assignee)) {
            throw new IllegalArgumentException("Assignee parameter must be non empty.");
        }
        if (this.userAccessor.getUserByName(assignee) == null) {
            throw new IllegalArgumentException("Invalid username: " + assignee);
        }
    }
}

