/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service.provider.confluence.filter;

import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.pages.Comment;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQueryFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.contract.CommentActivityFilter;
import com.comalatech.confluence.documentActivity.service.provider.confluence.filter.contract.PageEditActivityFilter;

public class DateRangeFilter
implements PageEditActivityFilter,
CommentActivityFilter {
    @Override
    public boolean filter(VersionHistorySummary version, InternalDocumentActivityQuery query) {
        return this.filterFromAndTo(version.getLastModificationDate().getTime(), (InternalDocumentActivityQueryFilter)query.getFilters());
    }

    @Override
    public boolean filter(Comment comment, InternalDocumentActivityQuery query) {
        return this.filterFromAndTo(comment.getCreationDate().getTime(), (InternalDocumentActivityQueryFilter)query.getFilters());
    }

    private boolean filterFromAndTo(Long activityMoment, InternalDocumentActivityQueryFilter filters) {
        if (filters != null) {
            return this.match(activityMoment, Comparators.GREATER_EQUAL, filters.getFromDate()) && this.match(activityMoment, Comparators.LESSER_EQUAL, filters.getToDate());
        }
        return true;
    }

    private boolean match(Long activityMoment, Comparators comparator, Long momentToCompare) {
        switch (comparator) {
            case LESSER_EQUAL: {
                return activityMoment <= (momentToCompare == null ? activityMoment : momentToCompare);
            }
            case GREATER_EQUAL: {
                return activityMoment >= (momentToCompare == null ? activityMoment : momentToCompare);
            }
        }
        return true;
    }

    public static enum Comparators {
        LESSER_EQUAL,
        GREATER_EQUAL;

    }
}

