/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.task;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskCompleteEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskCompleteEvent;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.workflow.WorkflowUserException;
import org.apache.commons.lang3.StringUtils;

public class TaskCompletionMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public TaskCompletionMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        if (event instanceof PageTaskCompleteEvent) {
            PageTaskCompleteEvent pageTaskCompleteEvent = (PageTaskCompleteEvent)event;
            return this.buildActivity((AbstractPage)pageTaskCompleteEvent.getPage(), (PageState)pageTaskCompleteEvent.getState(), (PageTask)pageTaskCompleteEvent.getTask(), pageTaskCompleteEvent.getCompletion());
        }
        if (event instanceof BlogPostTaskCompleteEvent) {
            BlogPostTaskCompleteEvent blogPostTaskCompleteEvent = (BlogPostTaskCompleteEvent)event;
            return this.buildActivity((AbstractPage)blogPostTaskCompleteEvent.getBlogPost(), (PageState)blogPostTaskCompleteEvent.getState(), (PageTask)blogPostTaskCompleteEvent.getTask(), blogPostTaskCompleteEvent.getCompletion());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, PageTask pageTask, TaskCompletion completion) throws WorkflowUserException {
        Actor actor = this.actorUtils.buildActor(completion.getPerformer());
        ActionDetails details = new ActionDetails();
        details.addDetail(ActionDetailType.TASK_NAME, pageTask.getName());
        String comment = completion.getComment();
        if (!StringUtils.isEmpty((CharSequence)comment)) {
            details.addDetail(ActionDetailType.TASK_COMMENT, comment);
        }
        details.addAll(this.buildStateActionDetails(state));
        Action action = new Action(new ActionType(ActionType.Type.TASK, ActionType.Subtype.TASK_COMPLETION), actor, details);
        return new Activity(TaskCompletionMapper.buildTarget((ContentEntityObject)abstractPage), completion.getDate().getTime(), action);
    }
}

