/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.state;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.event.blogpost.BlogPostStateTransitionEvent;
import com.comalatech.confluence.states.event.page.PageStateTransitionEvent;
import com.comalatech.confluence.states.model.PageState;

public class StateTransitionMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public StateTransitionMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) {
        if (event instanceof PageStateTransitionEvent) {
            PageStateTransitionEvent pageStateTransitionEvent = (PageStateTransitionEvent)event;
            return this.buildStateTransitionActivity((AbstractPage)pageStateTransitionEvent.getPage(), pageStateTransitionEvent.getState(), pageStateTransitionEvent.getPreviousEvent());
        }
        if (event instanceof BlogPostStateTransitionEvent) {
            BlogPostStateTransitionEvent blogPostStateTransitionEvent = (BlogPostStateTransitionEvent)event;
            return this.buildStateTransitionActivity((AbstractPage)blogPostStateTransitionEvent.getBlogPost(), blogPostStateTransitionEvent.getState(), blogPostStateTransitionEvent.getPreviousEvent());
        }
        return null;
    }

    protected Activity buildInitialStateSetActivity(AbstractPage abstractPage, PageState targetState) {
        return this.buildStateTransitionActivity(abstractPage, targetState, null);
    }

    protected Activity buildStateTransitionActivity(AbstractPage abstractPage, PageState targetState, PageState sourceState) {
        Actor actor = this.actorUtils.buildActor(targetState.getPerformer());
        ActionDetails details = new ActionDetails();
        details.addAll(this.buildStateActionDetails(targetState));
        if (targetState.getComment() != null && !targetState.getComment().isEmpty()) {
            details.addDetail(ActionDetailType.STATE_COMMENT, targetState.getComment());
        }
        if (sourceState != null) {
            details.addDetail(ActionDetailType.STATE_SOURCE, sourceState.getName());
        }
        Action action = new Action(new ActionType(ActionType.Type.STATE, ActionType.Subtype.STATE_TRANSITION), actor, details);
        return new Activity(StateTransitionMapper.buildTarget((ContentEntityObject)abstractPage), targetState.getDate().getTime(), action);
    }
}

