/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.approval;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.events.BlogPostApprovalRejectEvent;
import com.comalatech.confluence.workflow.events.PageApprovalRejectEvent;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.workflow.model.SignatureType;
import com.google.gson.Gson;
import java.util.ArrayList;

public class ApprovalRejectedMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public ApprovalRejectedMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        if (event instanceof PageApprovalRejectEvent) {
            PageApprovalRejectEvent pageApprovalRejectEvent = (PageApprovalRejectEvent)event;
            return this.buildActivity(pageApprovalRejectEvent.getAbstractPage(), pageApprovalRejectEvent.getState(), pageApprovalRejectEvent.getApprovalCheck(), pageApprovalRejectEvent.getApprovalCheck().getLastApprover(), pageApprovalRejectEvent.isPartial());
        }
        if (event instanceof BlogPostApprovalRejectEvent) {
            BlogPostApprovalRejectEvent blogPostApprovalRejectEvent = (BlogPostApprovalRejectEvent)event;
            return this.buildActivity(blogPostApprovalRejectEvent.getAbstractPage(), blogPostApprovalRejectEvent.getState(), blogPostApprovalRejectEvent.getApprovalCheck(), blogPostApprovalRejectEvent.getApprovalCheck().getLastApprover(), blogPostApprovalRejectEvent.isPartial());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, ApprovalCheck approvalCheck, Approver approver, boolean isPartial) throws WorkflowUserException {
        Action action;
        Actor actor = this.actorUtils.buildActor(approver.getUserName());
        ActionDetails details = this.buildApprovalsActionDetails(approvalCheck.getName(), approvalCheck.getId(), approver.getComment());
        if (!isPartial) {
            details.addDetail(ActionDetailType.REJECTION_TIME_LAPSED, String.valueOf(approver.getDate().getTime() - state.getDate().getTime()));
            this.addRequiredApprovers(approvalCheck, details);
            this.addApproversAndRejectors(approvalCheck, details);
            action = new Action(new ActionType(ActionType.Type.APPROVAL, ActionType.Subtype.APPROVAL_FULLY_REJECTED), actor, details);
        } else {
            action = new Action(new ActionType(ActionType.Type.APPROVAL, ActionType.Subtype.APPROVAL_REJECTED), actor, details);
        }
        if (approver.getSignatureType() != SignatureType.NONE) {
            details.addDetail(ActionDetailType.APPROVAL_SIGNATURE_MODE, approver.getESignature().toString());
            details.addDetail(ActionDetailType.APPROVAL_SIGNATURE_TYPE, approver.getSignatureType().toString());
        }
        details.addAll(this.buildRoleNameActionDetails(approver.getRole()));
        details.addAll(this.buildStateActionDetails(state));
        return new Activity(ApprovalRejectedMapper.buildTarget((ContentEntityObject)abstractPage), approver.getDate().getTime(), action);
    }

    private void addRequiredApprovers(ApprovalCheck approvalCheck, ActionDetails details) {
        if (approvalCheck.getRequiredApprovers() == null || approvalCheck.getRequiredApprovers().length == 0) {
            return;
        }
        ArrayList<String> requiredApproversUserkeys = new ArrayList<String>();
        for (String username : approvalCheck.getRequiredApprovers()) {
            requiredApproversUserkeys.add(this.actorUtils.buildActor(username).getId());
        }
        details.addDetail(ActionDetailType.APPROVAL_REQUIRED_APPROVERS, new Gson().toJson(requiredApproversUserkeys.toArray()));
    }

    private void addApproversAndRejectors(ApprovalCheck approvalCheck, ActionDetails details) {
        if (approvalCheck.getApprovers() == null || approvalCheck.getApprovers().length == 0) {
            return;
        }
        ArrayList<String> approversUserkeys = new ArrayList<String>();
        ArrayList<String> rejectorsUserkeys = new ArrayList<String>();
        for (Approver approverUser : approvalCheck.getApprovers()) {
            if (approverUser.isApproved()) {
                approversUserkeys.add(this.actorUtils.buildActor(approverUser.getUserName()).getId());
                continue;
            }
            rejectorsUserkeys.add(this.actorUtils.buildActor(approverUser.getUserName()).getId());
        }
        if (!rejectorsUserkeys.isEmpty()) {
            details.addDetail(ActionDetailType.APPROVAL_REJECTORS, new Gson().toJson(rejectorsUserkeys.toArray()));
        }
        if (!approversUserkeys.isEmpty()) {
            details.addDetail(ActionDetailType.APPROVAL_APPROVERS, new Gson().toJson(approversUserkeys.toArray()));
        }
    }
}

