/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.mappers.activity.state;

import com.comalatech.confluence.cloud.migration.entity.domain.activity.state.StateTransition;
import com.comalatech.confluence.cloud.migration.usecases.mappers.ActivityMapper;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;

public class StateTransitionMapper
extends ActivityMapper {
    private static final String STATE_CHANGE = "changeState";

    @Override
    public StateTransition map(Activity activity) {
        if (activity == null) {
            return null;
        }
        StateTransition state = new StateTransition();
        this.populateCommonFields(state, activity);
        state.setAction(STATE_CHANGE);
        if (activity.getAction() != null && activity.getAction().getActionDetails() != null && activity.getAction().getActionDetails().getDetail(ActionDetailType.STATE_COLOUR) != null) {
            state.setColour(activity.getAction().getActionDetails().getDetail(ActionDetailType.STATE_COLOUR).getValue());
        }
        if (activity.getAction() != null && activity.getAction().getActors() != null) {
            state.setUser(this.actorListToPerformer(activity.getAction().getActors()));
        }
        return state;
    }

    @Override
    public boolean shouldApply(Activity activity) {
        if (activity == null) {
            return false;
        }
        return activity.getAction() != null && activity.getAction().getActionType() != null && ActionType.Type.STATE.equals((Object)activity.getAction().getActionType().getType()) && (ActionType.Subtype.STATE_TRANSITION.equals((Object)activity.getAction().getActionType().getSubtype()) || ActionType.Subtype.STATE_INIT.equals((Object)activity.getAction().getActionType().getSubtype()) || ActionType.Subtype.STATE_OVERRIDE.equals((Object)activity.getAction().getActionType().getSubtype()));
    }
}

