/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.mappers.activity.approval;

import com.comalatech.confluence.cloud.migration.entity.domain.activity.approval.ApprovalRejected;
import com.comalatech.confluence.cloud.migration.usecases.mappers.activity.approval.ApprovalActivityMapper;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;

public class ApprovalRejectedMapper
extends ApprovalActivityMapper {
    private static final String APPROVAL_REJECTED_ACTION = "reject";

    @Override
    public ApprovalRejected map(Activity activity) {
        if (activity == null) {
            return null;
        }
        ApprovalRejected rejection = new ApprovalRejected();
        rejection = (ApprovalRejected)this.map(rejection, activity);
        this.populateCommonFields(rejection, activity);
        rejection.setAction(APPROVAL_REJECTED_ACTION);
        if (activity.getAction() != null && activity.getAction().getActors() != null) {
            rejection.setUser(this.actorListToPerformer(activity.getAction().getActors()));
        }
        if (activity.getAction() != null && activity.getAction().getActionDetails() != null && activity.getAction().getActionDetails().getDetail(ActionDetailType.APPROVAL_SIGNATURE_TYPE) != null) {
            ActionDetail signatureType = activity.getAction().getActionDetails().getDetail(ActionDetailType.APPROVAL_SIGNATURE_TYPE);
            rejection.setESignature("PASSWORD".equals(signatureType.getValue()) || "USERID_AND_PASSWORD".equals(signatureType.getValue()));
        }
        return rejection;
    }

    @Override
    public boolean shouldApply(Activity activity) {
        if (activity == null) {
            return false;
        }
        return activity.getAction() != null && activity.getAction().getActionType() != null && ActionType.Type.APPROVAL.equals((Object)activity.getAction().getActionType().getType()) && ActionType.Subtype.APPROVAL_REJECTED.equals((Object)activity.getAction().getActionType().getSubtype());
    }
}

