/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.infrastructure.serializer;

import com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.approval.ApprovalApproved;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.approval.ApprovalAssigned;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.approval.ApprovalRejected;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.approval.ApprovalUnassigned;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.state.StateDueDate;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.state.StateTransition;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class StateActivitySerializer
extends JsonSerializer<Activity> {
    @Override
    public void serialize(Activity activity, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("name", activity.getName());
        if (activity.getComment() != null) {
            gen.writeStringField("comment", activity.getComment());
        }
        gen.writeStringField("action", activity.getAction());
        gen.writeNumberField("timeStamp", activity.getTimestamp());
        gen.writeNumberField("contentVersion", activity.getContentVersion());
        if (activity instanceof ApprovalAssigned) {
            this.serializeApprovalAssigned((ApprovalAssigned)activity, gen);
        } else if (activity instanceof ApprovalUnassigned) {
            this.serializeApprovalUnassigned((ApprovalUnassigned)activity, gen);
        } else if (activity instanceof ApprovalApproved) {
            this.serializeApprovalApproved((ApprovalApproved)activity, gen);
        } else if (activity instanceof ApprovalRejected) {
            this.serializeApprovalRejected((ApprovalRejected)activity, gen);
        } else if (activity instanceof StateDueDate) {
            this.serializeStateDueDate((StateDueDate)activity, gen);
        } else if (activity instanceof StateTransition) {
            this.serializeStateTransition((StateTransition)activity, gen);
        }
        gen.writeEndObject();
    }

    private void serializeApprovalAssigned(ApprovalAssigned activity, JsonGenerator gen) throws IOException {
        gen.writeStringField("user", activity.getUser().getAccountId());
        gen.writeStringField("assigner", activity.getAssigner().getAccountId());
        gen.writeStringField("approval", activity.getApproval());
    }

    private void serializeApprovalUnassigned(ApprovalUnassigned activity, JsonGenerator gen) throws IOException {
        gen.writeStringField("user", activity.getUser().getAccountId());
        gen.writeStringField("assigner", activity.getAssigner().getAccountId());
        gen.writeStringField("approval", activity.getApproval());
    }

    private void serializeApprovalApproved(ApprovalApproved activity, JsonGenerator gen) throws IOException {
        gen.writeStringField("user", activity.getUser().getAccountId());
        gen.writeBooleanField("eSignature", activity.isESignature());
        gen.writeStringField("approval", activity.getApproval());
    }

    private void serializeApprovalRejected(ApprovalRejected activity, JsonGenerator gen) throws IOException {
        gen.writeStringField("user", activity.getUser().getAccountId());
        gen.writeBooleanField("eSignature", activity.isESignature());
        gen.writeStringField("approval", activity.getApproval());
    }

    private void serializeStateDueDate(StateDueDate activity, JsonGenerator gen) throws IOException {
        gen.writeStringField("user", activity.getUser().getAccountId());
        gen.writeStringField("dueDate", activity.getDueDate());
    }

    private void serializeStateTransition(StateTransition activity, JsonGenerator gen) throws IOException {
        gen.writeStringField("user", activity.getUser().getAccountId());
        if (activity.getColour() != null) {
            gen.writeStringField("colour", activity.getColour());
        }
    }
}

