/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.infrastructure;

import com.comalatech.confluence.cloud.migration.entity.domain.activity.Actor;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.State;
import com.comalatech.confluence.cloud.migration.usecases.contracts.Presenter;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jacksonMixins.MigrationActorMixin;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jacksonMixins.MigrationStateMixin;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="jsonPresenter")
public class JsonPresenter
implements Presenter<String> {
    private static final Logger log = LoggerFactory.getLogger(JsonPresenter.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonPresenter() {
        this.mapper.addMixIn(Actor.class, MigrationActorMixin.class);
        this.mapper.addMixIn(State.class, MigrationStateMixin.class);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public <U> String present(List<U> elements) {
        String result;
        try {
            result = this.mapper.writeValueAsString(elements);
            if (result.equalsIgnoreCase("null")) {
                result = "{}";
            }
        }
        catch (Exception e) {
            log.error("Error serializing data {}", elements, (Object)e);
            result = "{}";
        }
        return result;
    }

    @Override
    public <U> String present(U element) {
        String result;
        try {
            result = this.mapper.writeValueAsString(element);
            if (result.equalsIgnoreCase("null")) {
                result = "{}";
            }
        }
        catch (Exception e) {
            log.error("Error serializing data {}", element, (Object)e);
            result = "{}";
        }
        return result;
    }
}

