/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.migration.app.disco.TransferInfo;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.MigrationEntity;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.State;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.StateHistory;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.pageactivity.PageActivityMigrationEntity;
import com.comalatech.confluence.cloud.migration.model.mappings.ContentMapping;
import com.comalatech.confluence.cloud.migration.support.commands.MappingCSV;
import com.comalatech.confluence.cloud.migration.support.model.MappingsCSVData;
import com.comalatech.confluence.cloud.migration.usecases.MigrationLabel;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudMappingsData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.ContentMigrationProcessor;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivity;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivityMigrationData;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationNamesSpaces;
import com.comalatech.confluence.cloud.migration.usecases.mappers.StateMapper;
import com.comalatech.confluence.cloud.migration.utils.MigrationPackageFile;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.workflow.StateService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="pageActivityMigrationProcessor")
public class CurrentStateMigrationProcessor
implements ContentMigrationProcessor {
    private static final Logger log = LoggerFactory.getLogger(CurrentStateMigrationProcessor.class);
    private static final String PAGE_ACTIVITY_MIGRATION_VERSION = "1";
    private static final String BLOGS = "blog";
    private static final String PAGES = "pages";
    private static final String USERS = "users";
    private final PageManager pageManager;
    private final CloudPopulationData<State> userPopulationData;
    private final CloudPopulationData<State> contentPopulationData;
    private final CloudMappingsData cloudMappingsData;
    private final ContentPermissionManager contentPermissionManager;
    private final SystemInformationService systemInformationService;
    private final GeneratePageActivityMigrationData pageActivityGeneratorUseCase;
    private final GeneratePageActivity generatePageActivity;
    private final StateMapper stateMapper;
    private final MappingCSV mappingCSV;

    public CurrentStateMigrationProcessor(@Qualifier(value="cloudPageActivityUserIdPopulationUseCase") CloudPopulationData<State> userPopulationData, @Qualifier(value="cloudPageActivityContentIdPopulationUseCase") CloudPopulationData<State> contentPopulationData, CloudMappingsData cloudMappingsData, @ComponentImport PageManager pageManager, SupportPresenter templateFileLayoutHelper, @ComponentImport ContentPermissionManager contentPermissionManager, @ComponentImport SystemInformationService systemInformationService, WorkflowAccessor workflowAccessor, ApprovalManager approvalManager, UserAccessor userAccessor, StateService stateService, GeneratePageActivityMigrationData pageActivityGeneratorUseCase, GeneratePageActivity generatePageActivity) {
        this.userPopulationData = userPopulationData;
        this.contentPopulationData = contentPopulationData;
        this.cloudMappingsData = cloudMappingsData;
        this.pageManager = pageManager;
        this.contentPermissionManager = contentPermissionManager;
        this.systemInformationService = systemInformationService;
        this.pageActivityGeneratorUseCase = pageActivityGeneratorUseCase;
        this.generatePageActivity = generatePageActivity;
        this.stateMapper = new StateMapper(workflowAccessor, approvalManager, stateService, userAccessor);
        this.mappingCSV = new MappingCSV(templateFileLayoutHelper);
    }

    @Override
    public <T> Migration process(AppCloudMigrationGateway gateway, Map<AbstractPage, T> pageActivities, TransferInfo transferInfo, MigrationDetailsV1 migrationDetails) throws Exception {
        Map<AbstractPage, LinkedHashMap<PageState, List<Activity>>> _pageActivities = pageActivities;
        Map<String, Set<String>> localIds = this.idExtractor(_pageActivities);
        String transferId = transferInfo.getTransferId().toString();
        Map<String, String> userMapping = this.cloudMappingsData.getCloudMappings(gateway, transferId, MigrationNamesSpaces.USERS_KEY.toString(), localIds.get(USERS));
        Map<String, String> contentMapping = this.cloudMappingsData.getCloudMappings(gateway, transferId, MigrationNamesSpaces.CONFLUENCE_PAGES.toString(), localIds.get(PAGES));
        Map<String, String> blogPostMapping = this.cloudMappingsData.getCloudMappings(gateway, transferId, MigrationNamesSpaces.CONFLUENCE_BLOGPOST.toString(), localIds.get(BLOGS));
        contentMapping.putAll(blogPostMapping);
        Migration cloudMigration = new Migration();
        _pageActivities.entrySet().parallelStream().forEach(content -> {
            Set contentStates = ((LinkedHashMap)content.getValue()).entrySet().parallelStream().map(state -> this.stateMapper.map((AbstractPage)content.getKey(), (List)state.getValue())).filter(Objects::nonNull).map(state -> this.userPopulationData.populateCloudData((State)state, userMapping)).map(state -> this.contentPopulationData.populateCloudData((State)state, contentMapping)).map(state -> new StateHistory((State)state, state.getActivities())).collect(Collectors.toCollection(ConcurrentHashMap::newKeySet));
            String cloudContentKey = (String)contentMapping.get(String.valueOf(((AbstractPage)content.getKey()).getId()));
            if (cloudContentKey == null) {
                log.error("Cloud mapping for {} not found", (Object)((AbstractPage)content.getKey()).getId());
            }
            cloudMigration.migrationEntities.add(this.populateMigrationEntity((AbstractPage)content.getKey(), cloudContentKey, contentStates));
        });
        cloudMigration.totalNumberOfMigrationItems = cloudMigration.migrationEntities.size();
        cloudMigration.migrationPeerSEN = this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber();
        cloudMigration.version = PAGE_ACTIVITY_MIGRATION_VERSION;
        cloudMigration.label = MigrationLabel.PAGE_ACTIVITY.getLabel();
        return cloudMigration;
    }

    private Map<String, Set<String>> idExtractor(Map<AbstractPage, LinkedHashMap<PageState, List<Activity>>> pageActivities) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        ConcurrentHashMap.KeySetView pagesID = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView blogPostID = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView usersID = ConcurrentHashMap.newKeySet();
        pageActivities.entrySet().parallelStream().forEach(content -> {
            AbstractPage abstractPage = (AbstractPage)content.getKey();
            if (abstractPage instanceof Page) {
                pagesID.add(String.valueOf(abstractPage.getId()));
            } else {
                blogPostID.add(String.valueOf(abstractPage.getId()));
            }
            ((LinkedHashMap)content.getValue()).forEach((state, activities) -> activities.forEach(act -> {
                for (Actor actor : act.getAction().getActors()) {
                    usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + actor.getId());
                }
                if (ActionType.Type.APPROVAL.equals((Object)act.getAction().getActionType().getType())) {
                    ActionDetail unassignee;
                    ActionDetail assignee;
                    if (ActionType.Subtype.APPROVAL_ASSIGNED.equals((Object)act.getAction().getActionType().getSubtype()) && (assignee = act.getAction().getActionDetails().getDetail(ActionDetailType.APPROVAL_USER_ASSIGNED)) != null && assignee.getValue() != null) {
                        usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + assignee.getValue());
                    }
                    if (ActionType.Subtype.APPROVAL_UNASSIGNED.equals((Object)act.getAction().getActionType().getSubtype()) && (unassignee = act.getAction().getActionDetails().getDetail(ActionDetailType.APPROVAL_USER_UNASSIGNED)) != null && unassignee.getValue() != null) {
                        usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + unassignee.getValue());
                    }
                }
            }));
        });
        result.put(PAGES, pagesID);
        result.put(BLOGS, blogPostID);
        result.put(USERS, usersID);
        return result;
    }

    @Override
    public Migration debug(List<String> spaceKeys) throws Exception {
        Migration cloudMigration = new Migration();
        HashMap<AbstractPage, LinkedHashMap<PageState, List<Activity>>> pageActivities = new HashMap<AbstractPage, LinkedHashMap<PageState, List<Activity>>>(this.pageActivityGeneratorUseCase.getActivities(spaceKeys));
        pageActivities.entrySet().parallelStream().forEach(content -> {
            Set contentStates = ((LinkedHashMap)content.getValue()).entrySet().parallelStream().map(state -> this.stateMapper.map((AbstractPage)content.getKey(), (List)state.getValue())).map(state -> new StateHistory((State)state, state.getActivities())).collect(Collectors.toCollection(ConcurrentHashMap::newKeySet));
            cloudMigration.migrationEntities.add(this.populateMigrationEntity((AbstractPage)content.getKey(), String.valueOf(((AbstractPage)content.getKey()).getId()), contentStates));
        });
        cloudMigration.totalNumberOfMigrationItems = cloudMigration.migrationEntities.size();
        cloudMigration.migrationPeerSEN = this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber();
        cloudMigration.version = PAGE_ACTIVITY_MIGRATION_VERSION;
        return cloudMigration;
    }

    @Override
    public Migration debug(AbstractPage content) throws Exception {
        Migration cloudMigration = new Migration();
        LinkedHashMap<PageState, List<Activity>> activities = this.generatePageActivity.generateCurrentStateActivities(content);
        if (activities != null) {
            activities.entrySet().parallelStream().map(entry -> {
                State state = this.stateMapper.map(content, (List)entry.getValue());
                StateHistory stateHistory = new StateHistory(state, state.getActivities());
                return this.populateMigrationEntity(content, String.valueOf(content.getId()), Set.of(stateHistory));
            }).forEach(cloudMigration.migrationEntities::add);
        }
        cloudMigration.totalNumberOfMigrationItems = cloudMigration.migrationEntities.size();
        cloudMigration.migrationPeerSEN = this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber();
        cloudMigration.version = PAGE_ACTIVITY_MIGRATION_VERSION;
        return cloudMigration;
    }

    private void generateContentMappingsCSV(Map<String, String> migrationMappings, MigrationDetailsV1 migrationDetails, String transferId) {
        ArrayList<ContentMapping> contentMappings = new ArrayList<ContentMapping>();
        migrationMappings.forEach((serverId, cloudID) -> {
            ContentMapping mapping = new ContentMapping();
            AbstractPage content = this.pageManager.getAbstractPage(Long.parseLong(serverId));
            if (content != null) {
                mapping.setTitle(content.getTitle());
                mapping.setServerID((String)serverId);
                mapping.setCloudID((String)cloudID);
            }
            contentMappings.add(mapping);
        });
        if (!contentMappings.isEmpty()) {
            try {
                Path path = MigrationPackageFile.generateMigrationFolder();
                this.mappingCSV.generateSupportFile(MappingsCSVData.builder().mappings(contentMappings).migrationName(StringUtils.deleteWhitespace((String)MigrationPackageFile.makeSafe(migrationDetails.getName()))).transferId(transferId).build(), path);
            }
            catch (IOException e) {
                log.error("Error generating migration mappings csv: {}", (Object)e.getMessage());
            }
        }
    }

    private boolean checkContentRestrictions(Long contentServerId) {
        boolean isRestricted = false;
        AbstractPage content = this.pageManager.getAbstractPage(contentServerId.longValue());
        if (content != null) {
            if (content.getContentPermissionSet("View") != null || content.getContentPermissionSet("Edit") != null) {
                isRestricted = true;
            } else {
                List inheritedPermissions = this.contentPermissionManager.getInheritedContentPermissionSets((ContentEntityObject)content);
                if (inheritedPermissions != null && !inheritedPermissions.isEmpty()) {
                    isRestricted = true;
                }
            }
        }
        return isRestricted;
    }

    private MigrationEntity populateMigrationEntity(AbstractPage content, String cloudContentId, Set<StateHistory> stateHistory) {
        boolean isRestricted;
        PageActivityMigrationEntity migrationEntity = new PageActivityMigrationEntity();
        migrationEntity.setStateHistory(stateHistory);
        migrationEntity.setSpaceKey(content.getSpaceKey());
        migrationEntity.setContentId(cloudContentId);
        migrationEntity.setServerId(content.getIdAsString());
        migrationEntity.setType(content instanceof Page ? PageActivityMigrationEntity.Type.PAGE.toString() : PageActivityMigrationEntity.Type.BLOGPOST.toString());
        try {
            isRestricted = this.checkContentRestrictions(content.getId());
        }
        catch (Exception e) {
            log.warn("There was an error getting the content restrictions for page id {}: {}", (Object)content.getIdAsString(), (Object)e.getMessage());
            isRestricted = true;
        }
        migrationEntity.setRestricted(isRestricted);
        return migrationEntity;
    }
}

