/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.migration.app.disco.TransferInfo;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.MigrationEntity;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.csvactivity.CsvActivity;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.csvactivity.CsvActivityMigrationEntity;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.pageactivity.PageActivityMigrationEntity;
import com.comalatech.confluence.cloud.migration.usecases.MigrationLabel;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudMappingsData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.ContentMigrationProcessor;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationNamesSpaces;
import com.comalatech.confluence.cloud.migration.usecases.mappers.csvreport.CsvEntryMapper;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="csvActivityMigrationProcessor")
public class CsvActivityMigrationProcessor
implements ContentMigrationProcessor {
    private static final Logger log = LoggerFactory.getLogger(CsvActivityMigrationProcessor.class);
    private static final String CSV_ACTIVITY_MIGRATION_VERSION = "1";
    private static final String BLOGS = "blog";
    private static final String PAGES = "pages";
    private static final String USERS = "users";
    private final PageManager pageManager;
    private final CloudPopulationData<CsvActivity> userPopulationData;
    private final CloudMappingsData cloudMappingsData;
    private final ContentPermissionManager contentPermissionManager;
    private final SystemInformationService systemInformationService;
    private ActivityManager activityManager;
    private final CsvEntryMapper csvEntryMapper;

    public CsvActivityMigrationProcessor(@Qualifier(value="cloudCsvActivityUserIdPopulationUseCase") CloudPopulationData<CsvActivity> userPopulationData, CloudMappingsData cloudMappingsData, @ComponentImport PageManager pageManager, @ComponentImport ContentPermissionManager contentPermissionManager, @ComponentImport SystemInformationService systemInformationService, @ComponentImport UserAccessor userAccessor, @ComponentImport LocaleManager localeManager, @ComponentImport I18nResolver i18nResolver) {
        this.userPopulationData = userPopulationData;
        this.cloudMappingsData = cloudMappingsData;
        this.pageManager = pageManager;
        this.contentPermissionManager = contentPermissionManager;
        this.systemInformationService = systemInformationService;
        this.csvEntryMapper = new CsvEntryMapper(new ReportDateFormatter(localeManager, userAccessor), i18nResolver, userAccessor);
    }

    @Override
    public <T> Migration process(AppCloudMigrationGateway gateway, Map<AbstractPage, T> pageActivities, TransferInfo transferInfo, MigrationDetailsV1 migrationDetails) throws Exception {
        Map<AbstractPage, LinkedHashMap<PageState, List<Activity>>> _pageActivities = pageActivities;
        this.activityManager = PluginContainerManager.getComponent(ActivityManager.class);
        String transferId = transferInfo.getTransferId().toString();
        Map<String, Set<String>> localIds = this.contentIdExtractor(_pageActivities);
        Map<String, String> contentMapping = this.cloudMappingsData.getCloudMappings(gateway, transferId, MigrationNamesSpaces.CONFLUENCE_PAGES.toString(), localIds.get(PAGES));
        Map<String, String> blogPostMapping = this.cloudMappingsData.getCloudMappings(gateway, transferId, MigrationNamesSpaces.CONFLUENCE_BLOGPOST.toString(), localIds.get(BLOGS));
        contentMapping.putAll(blogPostMapping);
        Migration cloudMigration = new Migration();
        _pageActivities.keySet().parallelStream().forEach(content -> {
            ActivityReportOptions exportOptions = new ActivityReportOptions(false, false, false, false, false, false, Integer.MAX_VALUE);
            List<ActivityReportEntry> activityReportEntries = this.activityManager.getActivityReport((AbstractPage)content, exportOptions);
            List<CsvActivity> csvActivities = this.csvEntryMapper.map(activityReportEntries);
            Map<String, Set<String>> localUserIds = this.usersIdExtractor(csvActivities);
            Map<String, String> userMapping = this.cloudMappingsData.getCloudMappings(gateway, transferId, MigrationNamesSpaces.USERS_KEY.toString(), localUserIds.get(USERS));
            csvActivities = csvActivities.stream().map(csvActivity -> this.userPopulationData.populateCloudData((CsvActivity)csvActivity, userMapping)).collect(Collectors.toList());
            String cloudContentKey = (String)contentMapping.get(String.valueOf(content.getId()));
            if (cloudContentKey == null) {
                log.error("Cloud mapping for {} not found", (Object)content.getId());
            }
            cloudMigration.migrationEntities.add(this.populateMigrationEntity((AbstractPage)content, cloudContentKey, csvActivities));
        });
        cloudMigration.totalNumberOfMigrationItems = cloudMigration.migrationEntities.size();
        cloudMigration.migrationPeerSEN = this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber();
        cloudMigration.version = CSV_ACTIVITY_MIGRATION_VERSION;
        cloudMigration.label = MigrationLabel.CSV_ACTIVITY.getLabel();
        return cloudMigration;
    }

    private Map<String, Set<String>> contentIdExtractor(Map<AbstractPage, LinkedHashMap<PageState, List<Activity>>> pageActivities) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        ConcurrentHashMap.KeySetView pagesID = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView blogPostID = ConcurrentHashMap.newKeySet();
        pageActivities.keySet().parallelStream().forEach(content -> {
            if (content instanceof Page) {
                pagesID.add(String.valueOf(content.getId()));
            } else {
                blogPostID.add(String.valueOf(content.getId()));
            }
        });
        result.put(PAGES, pagesID);
        result.put(BLOGS, blogPostID);
        return result;
    }

    private Map<String, Set<String>> usersIdExtractor(List<CsvActivity> csvActivities) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        ConcurrentHashMap.KeySetView usersID = ConcurrentHashMap.newKeySet();
        csvActivities.parallelStream().forEach(csvActivity -> {
            CsvActivity.CsvActivityDescription csvActivityDescription;
            List<String> contributors;
            String user = csvActivity.getUser();
            if (user != null) {
                usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + user);
            }
            if ((contributors = csvActivity.getContributors()) != null && !contributors.isEmpty()) {
                for (String contributor : contributors) {
                    usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + contributor);
                }
            }
            if ((csvActivityDescription = csvActivity.getDescription()) != null && csvActivityDescription.getUsers() != null && !csvActivityDescription.getUsers().isEmpty()) {
                for (String userId : csvActivityDescription.getUsers()) {
                    usersID.add(MigrationNamesSpaces.USERS_KEY_PREFIX + userId);
                }
            }
        });
        result.put(USERS, usersID);
        return result;
    }

    @Override
    public Migration debug(List<String> spaceKeys) throws Exception {
        return null;
    }

    @Override
    public Migration debug(AbstractPage content) throws Exception {
        this.activityManager = PluginContainerManager.getComponent(ActivityManager.class);
        Migration cloudMigration = new Migration();
        ActivityReportOptions exportOptions = new ActivityReportOptions(false, false, false, false, false, false, Integer.MAX_VALUE);
        List<ActivityReportEntry> activityReportEntries = this.activityManager.getActivityReport(content, exportOptions);
        ArrayList<CsvActivity> contentActivities = new ArrayList<CsvActivity>();
        if (activityReportEntries != null && !activityReportEntries.isEmpty()) {
            contentActivities.addAll(this.csvEntryMapper.map(activityReportEntries));
        }
        cloudMigration.migrationEntities.add(this.populateMigrationEntity(content, content.getIdAsString(), contentActivities));
        cloudMigration.totalNumberOfMigrationItems = cloudMigration.migrationEntities.size();
        cloudMigration.migrationPeerSEN = this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber();
        cloudMigration.version = CSV_ACTIVITY_MIGRATION_VERSION;
        return cloudMigration;
    }

    private boolean checkContentRestrictions(Long contentServerId) {
        boolean isRestricted = false;
        AbstractPage content = this.pageManager.getAbstractPage(contentServerId.longValue());
        if (content != null) {
            if (content.getContentPermissionSet("View") != null || content.getContentPermissionSet("Edit") != null) {
                isRestricted = true;
            } else {
                List inheritedPermissions = this.contentPermissionManager.getInheritedContentPermissionSets((ContentEntityObject)content);
                if (inheritedPermissions != null && !inheritedPermissions.isEmpty()) {
                    isRestricted = true;
                }
            }
        }
        return isRestricted;
    }

    private MigrationEntity populateMigrationEntity(AbstractPage content, String cloudContentId, List<CsvActivity> activities) {
        boolean isRestricted;
        CsvActivityMigrationEntity migrationEntity = new CsvActivityMigrationEntity();
        migrationEntity.setActivities(activities);
        migrationEntity.setSpaceKey(content.getSpaceKey());
        migrationEntity.setContentId(cloudContentId);
        migrationEntity.setServerId(content.getIdAsString());
        migrationEntity.setType(content instanceof Page ? PageActivityMigrationEntity.Type.PAGE.toString() : PageActivityMigrationEntity.Type.BLOGPOST.toString());
        try {
            isRestricted = this.checkContentRestrictions(content.getId());
        }
        catch (Exception e) {
            log.warn("There was an error getting the content restrictions for page id {}: {}", (Object)content.getIdAsString(), (Object)e.getMessage());
            isRestricted = true;
        }
        migrationEntity.setRestricted(isRestricted);
        return migrationEntity;
    }
}

