/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.cloud.migration.entity.domain.metadata.Metadata;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationNamesSpaces;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="cloudMetadataUserIdPopulationUseCase")
public class CloudMetadataUserIdPopulationUseCase
implements CloudPopulationData<Metadata> {
    private static final Logger log = LoggerFactory.getLogger(CloudMetadataUserIdPopulationUseCase.class);
    private final UserAccessor userAccessor;

    public CloudMetadataUserIdPopulationUseCase(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public Metadata populateCloudData(Metadata metadata, Map<String, String> userMappings) {
        if (metadata == null) {
            log.warn("No metadata provided to populate cloud data");
            return null;
        }
        if (metadata.getValue() == null) {
            log.warn("Metadata {} has no value for content id {}", (Object)metadata.getName(), (Object)metadata.getContentId());
            return null;
        }
        if (Metadata.ContentType.WORKFLOW_PARAMETER_USER.equals((Object)metadata.getType())) {
            String value = metadata.getValue();
            if (value.contains(",")) {
                String[] usernames = value.split(",");
                StringBuilder result = new StringBuilder();
                for (int i = 0; i < usernames.length; ++i) {
                    String username = usernames[i].trim();
                    String processedUsername = this.processUsername(username, userMappings);
                    result.append(processedUsername);
                    if (i >= usernames.length - 1) continue;
                    result.append(",");
                }
                metadata.setValue(result.toString());
            } else {
                String processedUsername = this.processUsername(value, userMappings);
                metadata.setValue(processedUsername);
            }
        }
        return metadata;
    }

    private String processUsername(String username, Map<String, String> userMappings) {
        String userKey;
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        if (Objects.nonNull(user) && userMappings.containsKey(userKey = MigrationNamesSpaces.USERS_KEY_PREFIX + user.getKey().getStringValue())) {
            return userMappings.get(userKey);
        }
        return username;
    }
}

