/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.migration.app.PaginatedMapping;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudMappingsData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CloudMappingsDataRetrievalUseCase
implements CloudMappingsData {
    private static final Logger log = LoggerFactory.getLogger(CloudMappingsDataRetrievalUseCase.class);

    @Override
    public Map<String, String> getCloudMappings(AppCloudMigrationGateway gateway, String transferId, String namespace) {
        PaginatedMapping userMapping = gateway.getPaginatedMapping(transferId, namespace, 5000);
        userMapping.next();
        return userMapping.getMapping();
    }

    @Override
    public Map<String, String> getCloudMappings(AppCloudMigrationGateway gateway, String transferId, String namespace, Set<String> mappingIds) {
        int MAX_SIZE = 99;
        HashSet<String> batch = new HashSet<String>(99);
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (String id : mappingIds) {
            log.debug("Retrieving mapping for id {}", (Object)id);
            batch.add(id);
            if (batch.size() != 99) continue;
            Map<String, String> gatewayMappings = gateway.getMappingById(transferId, namespace, batch);
            log.debug("Server-cloud mappings retrieved {}", gatewayMappings);
            mappings.putAll(gatewayMappings);
            batch = new HashSet(99);
        }
        if (!batch.isEmpty()) {
            Map<String, String> gatewayMappings = gateway.getMappingById(transferId, namespace, batch);
            log.debug("Last Server-cloud mappings retrieved {}", gatewayMappings);
            mappings.putAll(gatewayMappings);
        }
        return mappings;
    }
}

