/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.dao;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.dao.BandanaKeysDao;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultBandanaKeysDao
implements BandanaKeysDao {
    private static final Logger log = LoggerFactory.getLogger(DefaultBandanaKeysDao.class);
    private final BandanaManager bandanaManager;
    private Method getKeysMethod;

    public DefaultBandanaKeysDao(@ComponentImport BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        try {
            this.getKeysMethod = bandanaManager.getClass().getMethod("getKeys", BandanaContext.class);
        }
        catch (Exception e) {
            this.getKeysMethod = null;
        }
    }

    @Override
    public List<String> getKeys(String spaceKey, String keyPattern) {
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : this.getKeys((BandanaContext)new ConfluenceBandanaContext(spaceKey))) {
            if (!key.startsWith(keyPattern)) continue;
            keys.add(key);
        }
        return keys;
    }

    @Override
    public List<String> getKeysNotNull(String spaceKey, String keyPattern) {
        ArrayList<String> keys = new ArrayList<String>();
        ConfluenceBandanaContext context = new ConfluenceBandanaContext(spaceKey);
        for (String key : this.getKeys((BandanaContext)context)) {
            if (!key.startsWith(keyPattern) || this.bandanaManager.getValue((BandanaContext)context, key) == null) continue;
            keys.add(key);
        }
        return keys;
    }

    @Override
    public int getNumberOfEntriesWithValuePattern(String keyPattern, String pattern) {
        ConfluenceBandanaContext context = new ConfluenceBandanaContext();
        int count = 0;
        for (String key : this.getKeys((BandanaContext)context)) {
            Object value;
            if (!key.startsWith(keyPattern) || (value = this.bandanaManager.getValue((BandanaContext)context, key)) == null || !value.toString().startsWith(pattern)) continue;
            ++count;
        }
        return count;
    }

    private Iterable<String> getKeys(BandanaContext bandanaContext) {
        try {
            return (Iterable)this.getKeysMethod.invoke((Object)this.bandanaManager, bandanaContext);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

